% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{interpretability_score}
\alias{interpretability_score}
\title{Interpretability score (structure preservation + plausibility)}
\usage{
interpretability_score(P, W, use_q90 = TRUE)
}
\arguments{
\item{P}{Prior matrix (\eqn{T \times K}).}

\item{W}{Posterior matrix (\eqn{T \times K}).}

\item{use_q90}{If \code{TRUE} (default), use 90th percentile of relative changes;
if \code{FALSE}, use the maximum.}
}
\value{
Scalar interpretability score in \eqn{[0,1]}.
}
\description{
Balances two ideas: (i) \emph{preservation} of the average sectoral structure
(correlation between \code{colMeans(P)} y \code{colMeans(W)}; truncated at 0),
and (ii) \emph{plausibility} of relative changes
\eqn{|W\_bar - P\_bar| / (P\_bar + \varepsilon)}, summarized by the 90th
percentile (or the maximum). The score is
\deqn{0.6\cdot \mathrm{preservation} + 0.4\cdot \frac{1}{1+2\cdot \mathrm{change}}.}
}
\examples{
T <- 6; K <- 5
P <- matrix(runif(T*K), T); P <- P/rowSums(P)
W <- matrix(runif(T*K), T); W <- W/rowSums(W)
interpretability_score(P, W)

}
