% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{posterior_adaptive}
\alias{posterior_adaptive}
\title{Adaptive posterior based on sector volatility}
\usage{
posterior_adaptive(P, LT)
}
\arguments{
\item{P}{Prior matrix (\eqn{T \times K}); filas no negativas.}

\item{LT}{Likelihood matrix (\eqn{T \times K}); filas no negativas.}
}
\value{
Posterior matrix \eqn{W} (\eqn{T \times K}), filas suman 1.
}
\description{
Ajusta el *mixing* por sector según la volatilidad histórica del prior:
\deqn{\phi_k = \min\!\left(\frac{\sigma_k/\mu_k}{\overline{\sigma/\mu}}, 0.8\right)},
donde \eqn{\sigma_k/\mu_k} es la desviación estándar relativa de la columna \eqn{k}.
Sectores más volátiles reciben más peso de \eqn{LT}. Devuelve
\eqn{W = (1-\phi)\odot P + \phi\odot LT}{W = (1-phi)*P + phi*LT} renormalizado por filas.
}
\examples{
set.seed(1)
T <- 8; K <- 5
P  <- matrix(runif(T*K), T);  P  <- P  / rowSums(P)
LT <- matrix(runif(T*K), T); LT <- LT / rowSums(LT)
W <- posterior_adaptive(P, LT)

}
\seealso{
\code{\link{posterior_weighted}}, \code{\link{posterior_multiplicative}},
  \code{\link{posterior_dirichlet}}
}
