% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cepstral.R
\name{cep_get}
\alias{cep_get}
\title{Estimate Cepstral Coefficients from Periodogram}
\usage{
cep_get(perd, k0, frq)
}
\arguments{
\item{perd}{An matrix of periodogram.}

\item{k0}{Number of cepstral coefficients.}

\item{frq}{A vector of frequencies in \code{[0,1]}.}
}
\value{
A list with:
\describe{
\item{\code{f}}{An \code{N × k0} matrix of estimated cepstral coefficients.}
\item{\code{ff}}{An \code{N × K} matrix of smoothed log-spectra.}
}
}
\description{
Estimates replicate-specific cepstral coefficients and smoothed log-spectra
using a Fourier cosine basis and Whittle-type approximation.
}
\examples{
set.seed(123)
Y <- matrix(rnorm(20 * 5), nrow = 20, ncol = 5)
len <- nrow(Y)
L <- floor(len/2)-1
frq <- (1:L)/len
perd <- perd_get(Y)
result <- cep_get(perd = perd, k0 = 3, frq = frq)
}
