% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_colour_vector_from_palette}
\alias{get_colour_vector_from_palette}
\title{Get the vector of colours from a palette}
\usage{
get_colour_vector_from_palette(
  palette_name,
  is_inverse = FALSE,
  placeholder = "viridis::viridis"
)
}
\arguments{
\item{palette_name}{The name of the palette to retrieve. The naming should
follow the guidelines described in the \code{paletteer} package.}

\item{is_inverse}{Logical. If \code{TRUE}, the colours will be reversed.}

\item{placeholder}{The default palette to use if the specified palette is not
found. The default is "viridis::viridis".}
}
\value{
A vector of colours from the specified palette. If the palette is not
found, a default palette will be used. If \code{paletter} is not installed, an
error will be thrown.
}
\description{
Using the \code{paletteer} package, this function retrieves a vector
of colours from a specified palette. The function will look for both
discrete and continuous palettes. If the palette is not found, a default
option will be used.
}
