% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfp_soilphys.R
\name{cfp_soilphys}
\alias{cfp_soilphys}
\alias{cfp_soilphys.cfp_dat}
\alias{cfp_soilphys.data.frame}
\title{Soil physical parameters data}
\usage{
cfp_soilphys(x, ...)

\method{cfp_soilphys}{cfp_dat}(x, ...)

\method{cfp_soilphys}{data.frame}(x, id_cols, ...)
}
\arguments{
\item{x}{A data.frame with (at least) the following columns:
\describe{
\item{upper (cm) }{The upper bound of each step.}
\item{lower (cm)}{The lower bound of each step.}
\item{gas}{The gas of that step.}
\item{DS (\eqn{m^2 s^-1})}{The specific diffusion coefficient of that gas in
that step.} \item{c_air (\eqn{mol m^-3})}{The number density of air in that
step.} \item{any of \code{id_cols}}{All id_cols that identify one profile
uniquely.}

}}

\item{...}{Internal, must be empty.}

\item{id_cols}{Column names in data.frame that uniquely identify each
profile.}
}
\value{
A \code{cfp_soilphys} object.
}
\description{
Create a \link{cfp_soilphys} object. This is a data.frame containing layered
data of soil physical properties, at the minimum of the air density
\code{c_air} and diffusion coefficient \code{DS} for one or multiple soil
profiles.
Each soil profile is uniquely identified by columns in the data.frame
specified by the \code{id_cols} attribute. Each profile is further subdivided
into layers by columns \code{upper} and \code{lower}
(see \link{cfp_layered_profile}).
}
\examples{
cfp_soilphys(
  ConFluxPro::soilphys,
  id_cols = c("site", "Date", "gas")
)
### Also used to extract an soilphys object from cfp_dat
cfp_soilphys(ConFluxPro::base_dat)
}
\seealso{
Other data formats: 
\code{\link{cfp_dat}()},
\code{\link{cfp_gasdata}()},
\code{\link{cfp_layered_profile}()},
\code{\link{cfp_layers_map}()},
\code{\link{cfp_profile}()}
}
\concept{data formats}
