% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConFluxPro-package.R, R/filter.R
\name{filter}
\alias{filter}
\alias{filter.cfp_dat}
\title{Filter profiles}
\usage{
filter(.data, ..., .by = NULL, .preserve = FALSE)

\method{filter}{cfp_dat}(.data, ..., .preserve = FALSE)
}
\arguments{
\item{.data}{A \code{\link[=cfp_dat]{cfp_dat()}} object or its derivatives.}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> Expressions that
return a logical value, and are defined in terms of the variables in
\code{.data}. If multiple expressions are included, they are combined with the
\code{&} operator. Only rows for which all conditions evaluate to \code{TRUE} are
kept.}

\item{.by}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Optionally, a selection of columns to
group by for just this operation, functioning as an alternative to \code{\link[dplyr:group_by]{group_by()}}. For
details and examples, see \link[dplyr:dplyr_by]{?dplyr_by}.}

\item{.preserve}{Relevant when the \code{.data} input is grouped.
If \code{.preserve = FALSE} (the default), the grouping structure
is recalculated based on the resulting data, otherwise the grouping is kept as is.}
}
\value{
A subset of the original data.
}
\description{
Filter profiles by their \code{id_cols} or (where available) by their \code{prof_id}.
This is built on \code{\link[dplyr:filter]{dplyr::filter()}}.
}
\examples{
base_dat |>
  filter(site == "site_a")

base_dat |>
  filter(Date > "2022-03-01")

}
