% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Coxmos_mb_splsdacox_dynamic.R
\name{mb.splsdacox}
\alias{mb.splsdacox}
\title{MB.sPLS-DACOX}
\usage{
mb.splsdacox(
  X,
  Y,
  n.comp = 4,
  vector = NULL,
  design = NULL,
  MIN_NVAR = 1,
  MAX_NVAR = NULL,
  n.cut_points = 5,
  EVAL_METHOD = "AUC",
  x.center = TRUE,
  x.scale = FALSE,
  remove_near_zero_variance = TRUE,
  remove_zero_variance = TRUE,
  toKeep.zv = NULL,
  remove_non_significant = FALSE,
  alpha = 0.05,
  MIN_AUC_INCREASE = 0.01,
  pred.method = "cenROC",
  max.iter = 200,
  times = NULL,
  max_time_points = 15,
  MIN_EPV = 5,
  returnData = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{X}{List of numeric matrices or data.frames. Explanatory variables. Qualitative variables must be
transform into binary variables.}

\item{Y}{Numeric matrix or data.frame. Response variables. Object must have two columns named as
"time" and "event". For event column, accepted values are: 0/1 or FALSE/TRUE for censored and event
observations.}

\item{n.comp}{Numeric. Number of latent components to compute for the (s)PLS model (default: 4).}

\item{vector}{Numeric vector or list. Used for computing best number of variables. As many values as
components have to be provided. If vector = NULL, an automatic detection is perform (default: NULL). If
vector is a list, must be named as the names of X param followed by the number of variables to select.}

\item{design}{Numeric matrix. Matrix of size (number of blocks in X) x (number of blocks in X) with
values between 0 and 1. Each value indicates the strength of the relationship to be modeled between
two blocks; a value of 0 indicates no relationship, 1 is the maximum value. If NULL, auto-design is computed (default: NULL).}

\item{MIN_NVAR}{Numeric. Minimum range size for computing cut points to select the best number of
variables to use (default: 1).}

\item{MAX_NVAR}{Numeric. Maximum range size for computing cut points to select the best number of
variables to use (default: NULL).}

\item{n.cut_points}{Numeric. Number of cut points for searching the optimal number of variables.
If only two cut points are selected, minimum and maximum size are used. For MB approaches as many
as n.cut_points^n.blocks models will be computed as minimum (default: 5).}

\item{EVAL_METHOD}{Character. The selected metric will be use to compute the best
number of variables. Must be one of the following: "AUC", "IBS" or "C.Index" (default: "AUC").}

\item{x.center}{Logical. If x.center = TRUE, X matrix is centered to zero means (default: TRUE).}

\item{x.scale}{Logical. If x.scale = TRUE, X matrix is scaled to unit variances (default: FALSE).}

\item{remove_near_zero_variance}{Logical. If remove_near_zero_variance = TRUE, near zero variance
variables will be removed (default: TRUE).}

\item{remove_zero_variance}{Logical. If remove_zero_variance = TRUE, zero variance variables will
be removed (default: TRUE).}

\item{toKeep.zv}{Character vector. Name of variables in X to not be deleted by (near) zero variance
filtering (default: NULL).}

\item{remove_non_significant}{Logical. If remove_non_significant = TRUE, non-significant
variables/components in final cox model will be removed until all variables are significant by
forward selection (default: FALSE).}

\item{alpha}{Numeric. Numerical values are regarded as significant if they fall below the
threshold (default: 0.05).}

\item{MIN_AUC_INCREASE}{Numeric. Minimum improvement between different cross validation models to
continue evaluating higher values in the multiple tested parameters. If it is not reached for next
'MIN_COMP_TO_CHECK' models and the minimum 'MIN_AUC' value is reached, the evaluation stops
(default: 0.01).}

\item{pred.method}{Character. AUC evaluation algorithm method for evaluate the model performance.
Must be one of the following: "risksetROC", "survivalROC", "cenROC", "nsROC", "smoothROCtime_C",
"smoothROCtime_I" (default: "cenROC").}

\item{max.iter}{Numeric. Maximum number of iterations for PLS convergence (default: 200).}

\item{times}{Numeric vector. Time points where the AUC will be evaluated. If NULL, a maximum of
'max_time_points' points will be selected equally distributed (default: NULL).}

\item{max_time_points}{Numeric. Maximum number of time points to use for evaluating the model
(default: 15).}

\item{MIN_EPV}{Numeric. Minimum number of Events Per Variable (EPV) you want reach for the final
cox model. Used to restrict the number of variables/components can be computed in final cox models.
If the minimum is not meet, the model cannot be computed (default: 5).}

\item{returnData}{Logical. Return original and normalized X and Y matrices (default: TRUE).}

\item{verbose}{Logical. If verbose = TRUE, extra messages could be displayed (default: FALSE).}
}
\value{
Instance of class "Coxmos" and model "MB.sPLS-DACOX". The class contains the following
elements:
\code{X}: List of normalized X data information.
\itemize{
\item \code{(data)}: normalized X matrix
\item \code{(weightings)}: PLS weights
\item \code{(weightings_norm)}: PLS normalize weights
\item \code{(W.star)}: PLS W* vector
\item \code{(scores)}: PLS scores/variates
\item \code{(E)}: error matrices
\item \code{(x.mean)}: mean values for X matrix
\item \code{(x.sd)}: standard deviation for X matrix
}
\code{Y}: List of normalized Y data information.
\itemize{
\item \code{(deviance_residuals)}: deviance residual vector used as Y matrix in the sPLS.
\item \code{(dr.mean)}: mean values for deviance residuals Y matrix
\item \code{(dr.sd)}: standard deviation for deviance residuals Y matrix'
\item \code{(data)}: normalized X matrix
\item \code{(y.mean)}: mean values for Y matrix
\item \code{(y.sd)}: standard deviation for Y matrix'
}
\code{survival_model}: List of survival model information.
\itemize{
\item \code{fit}: coxph object.
\item \code{AIC}: AIC of cox model.
\item \code{BIC}: BIC of cox model.
\item \code{lp}: linear predictors for train data.
\item \code{coef}: Coefficients for cox model.
\item \code{YChapeau}: Y Chapeau residuals.
\item \code{Yresidus}: Y residuals.
}

\code{mb.model}: List of sPLS models computed for each block.

\code{n.comp}: Number of components selected.

\code{n.varX}: Number of variables selected for each block.

\code{call}: call function

\code{X_input}: X input matrix

\code{Y_input}: Y input matrix

\code{design}: Design used for the strength of the relationship to be modeled between blocks.

\code{B.hat}: PLS beta matrix

\code{R2}: sPLS acumulate R2

\code{alpha}: Significance threshold used.

\code{nsv}: Variables removed due to non-significance.

\code{nzv}: Variables removed by remove_near_zero_variance or remove_zero_variance.

\code{nz_coeffvar}: Variables removed by coefficient variation near zero.

\code{time}: time consumed for running the cox analysis.

\code{nzv}: Variables removed by remove_near_zero_variance or remove_zero_variance.

\code{nz_coeffvar}: Variables removed by coefficient variation near zero.

\code{time}: time consumed for running the cox analysis.
}
\description{
The MB.sPLS-DACOX function conducts a multi-block sparse partial least squares discriminant
analysis Cox (MB.sPLS-DACOX) using a dynamic variable selection approach. This analysis is
particularly suited for high-dimensional datasets where the goal is to identify the relationship
between explanatory variables and survival outcomes. The function outputs a model of class
"Coxmos" with an attribute labeled "MB.sPLS-DACOX".
}
\details{
The MB.sPLS-DACOX methodology is designed to handle multi-block datasets, where each block
represents a set of related variables. By employing a sparse partial least squares approach, the
function efficiently selects relevant variables from each block, ensuring that the final model is
both interpretable and predictive. The Cox proportional hazards model is then applied to the
selected variables to assess their association with survival outcomes.

The function offers flexibility in terms of parameter tuning. For instance, users can specify the
number of latent components to compute, the range of variables to consider for optimal selection,
and the evaluation metric (either AUC or c-index). Additionally, data preprocessing options are
available, such as centering and scaling of the explanatory variables, and removal of variables
with near-zero or zero variance.
}
\examples{
\donttest{
data("X_multiomic")
data("Y_multiomic")
X <- X_multiomic
X$mirna <- X$mirna[,1:50]
X$proteomic <- X$proteomic[,1:50]
Y <- Y_multiomic
mb.splsdacox(X, Y, n.comp = 2, vector = NULL, x.center = TRUE, x.scale = TRUE)
}
}
\references{
\insertRef{MixOmics}{Coxmos}
}
\author{
Pedro Salguero Garcia. Maintainer: pedsalga@upv.edu.es
}
