predict.DDPstar <-
function(object, what = NULL, newdata, 
	reg.select = NULL, 
	den.grid = NULL, 
	quant.probs = NULL,
	q.value = NULL,
	parallel = c("no", "multicore", "snow"), ncpus = 1, cl = NULL, ...) {
	
	names.cov <- object$fit$names_cov
	if(!all(is.na(newdata)) && !inherits(newdata, "data.frame")) {
		stop("Newdata (argument density) must be a data frame")
    }
    if(!all(is.na(newdata)) && length(names.cov) != 0 && sum(is.na(match(names.cov, names(newdata))))) {
		stop("Not all needed variables are supplied in newdata (argument density)")
    }

	if(!is.null(what) & !is.character(what)) {
		stop("'what' argument must be a character vector")
	}

	if(!all(what %in% c("regfun", "varfun", "denfun", "quantfun", "probfun"))) {
		stop("Unknown function in argument 'what'")
	}

	res <- list()
	res$newdata <- newdata

	if("regfun" %in% what) {
		res.reg <- predict_DDPstar.regfun(object = object, newdata = newdata, select = reg.select, parallel = parallel, ncpus = ncpus, cl = cl)
		res$regfun <- res.reg$regfun
		res$reg.select <- reg.select
	}

	if("varfun" %in% what) {
		all.vars <- all((1:object$fit$mm$iformula$npartial) %in% reg.select)
		if(("regfun" %in% what) & (is.null(reg.select) || all.vars)) {
			res.var <- predict_DDPstar.varfun(object = object, object.regfun = res.reg, newdata = newdata, parallel = parallel, ncpus = ncpus, cl = cl)
		} else {
			res.var <- predict_DDPstar.varfun(object = object, newdata = newdata, parallel = parallel, ncpus = ncpus, cl = cl)		
		}
		res$varfun <- res.var$varfun
	}

	# Perhaps this can be done in just one step!
	if("denfun" %in% what) {
		if(is.null(den.grid)) {
			den.grid <- seq(min(object$data_model$y), max(object$data_model$y), length = 100)
		}
		res.den <- predict_DDPstar.denfun(object = object, newdata = newdata, sequence = den.grid, parallel = parallel, ncpus = ncpus, cl = cl)
		res$denfun <- res.den$denfun
		res$den.grid <- den.grid
	}

	if("quantfun" %in% what) {
		if(is.null(quant.probs)) {
			quant.probs <- seq(0.1, 0.9, by = 0.1)
		}
		res.quant <- predict_DDPstar.quantfun(object = object, newdata = newdata, p = quant.probs, parallel = parallel, ncpus = ncpus, cl = cl)
		res$quantfun <- res.quant$quantfun
		res$quant.probs <- quant.probs
	}
	if("probfun" %in% what) {
		if(is.null(q.value)) {
			stop("For 'probfun' the argument 'q.value' should be provided")
		}
		res.prob <- predict_DDPstar.probfun(object = object, newdata = newdata, q.value = q.value, parallel = parallel, ncpus = ncpus, cl = cl)
		res$probfun <- res.prob$probfun
		res$q.value <- q.value
	}
	res	

}
