% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setdiff_all.R
\name{setdiff_all}
\alias{setdiff_all}
\title{Get the difference of two vectors in both directions.}
\usage{
setdiff_all(vec1, vec2)
}
\arguments{
\item{vec1}{First vector}

\item{vec2}{Second vector}
}
\value{
The difference between both vectors.
}
\description{
The base-R function `setdiff` is asymmetric meaning
  `setdiff(vec1, vec2)` is not the same as `setdiff(vec2, vec1)`.
  Only the first vector will be compared to the second vector and all
  elements not contained in the second are in the resulting vector.
  So if you also want in include all elements being in the second vector
  but not in the first, you can use this function. In this case you are
  searching for elements being in the union of both vectors but not
  in the intersect of both vectors. This function is a symmetric function.
  It doesn't matter in which order you input the vectors, the content
  will be the same. Only the order of the elements inside the output
  differs.
}
\examples{
\dontrun{
vec1 <- c(1,2,3,4)
vec2 <- c(3,4,5,6)
# setdiff(vec1, vec2) = c(1,2)
# setdiff(vec2, vec1) = c(5,6)
# setdiff_all(vec1, vec2) = c(1,2,5,6)
# setdiff_all(vec2, vec1) = c(5,6,1,2)
}

}
