% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DTS.R
\name{rdts}
\alias{rdts}
\title{Simulation from a discrete tempered stable distribution.}
\usage{
rdts(n, alpha, eta, tp = c(1, 1), tf = "poisson-tweedie", c = 1, zt = FALSE)
}
\arguments{
\item{n}{Number of observations.}

\item{alpha}{Index of stability; Number in (0,1)}

\item{eta}{A parameter, eta>0.}

\item{tp}{A vector of tempering parameters.}

\item{tf}{Tempering function. It can be one of the "discrete-stable", "discrete-truncated-stable",
"discrete-pRDTS", "poisson-tweedie", "exp-tempering", "beta-prime-tempering", "Pareto-tempering".}

\item{c}{The essential supremum of the tempering function.}

\item{zt}{Logical. If True it calculates zero-truncated probabilities.}
}
\value{
A vector of observations from a DTS distributions.
}
\description{
Simulation from a discrete tempered stable distribution.
}
\examples{
n <- 10
rdts(n, 0.5, 1)
}
\references{
M. Grabchak. Discrete tempered stable distributions. Methodology and Computing in Applied Probability, 24(3):1877-1890, 2021.
}
