% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI.R
\name{dbExistsTable,DatabaseConnectorConnection,character-method}
\alias{dbExistsTable,DatabaseConnectorConnection,character-method}
\title{Does a table exist?}
\usage{
\S4method{dbExistsTable}{DatabaseConnectorConnection,character}(conn, name, databaseSchema = NULL, ...)
}
\arguments{
\item{conn}{A \link[DBI:DBIConnection-class]{DBIConnection} object, as returned by
\code{\link[DBI:dbConnect]{dbConnect()}}.}

\item{name}{The table name, passed on to \code{\link[DBI:dbQuoteIdentifier]{dbQuoteIdentifier()}}. Options are:
\itemize{
\item a character string with the unquoted DBMS table name,
e.g. \code{"table_name"},
\item a call to \code{\link[DBI:Id]{Id()}} with components to the fully qualified table name,
e.g. \code{Id(schema = "my_schema", table = "table_name")}
\item a call to \code{\link[DBI:SQL]{SQL()}} with the quoted and fully qualified table name
given verbatim, e.g. \code{SQL('"my_schema"."table_name"')}
}}

\item{databaseSchema}{The name of the database schema. See details for platform-specific details.}

\item{...}{Other parameters passed on to methods.}
}
\value{
\code{dbExistsTable()} returns a logical scalar, \code{TRUE} if the table or view
specified by the \code{name} argument exists, \code{FALSE} otherwise.

This includes temporary tables if supported by the database.
}
\description{
Returns if a table given by name exists in the database.

}
\details{
The \code{databaseSchema} argument is interpreted differently according to the different platforms:
SQL Server and PDW: The databaseSchema schema should specify both the database and the schema, e.g.
'my_database.dbo'. Impala: the databaseSchema should specify the database. Oracle:
The databaseSchema should specify the Oracle 'user'. All other : The databaseSchema should
specify the schema.
}
\seealso{
Other DBIConnection generics: 
\code{\link[DBI]{DBIConnection-class}},
\code{\link[DBI]{dbAppendTable}()},
\code{\link[DBI]{dbAppendTableArrow}()},
\code{\link[DBI]{dbCreateTable}()},
\code{\link[DBI]{dbCreateTableArrow}()},
\code{\link[DBI]{dbDataType}()},
\code{\link[DBI]{dbDisconnect}()},
\code{\link[DBI]{dbExecute}()},
\code{\link[DBI]{dbGetException}()},
\code{\link[DBI]{dbGetInfo}()},
\code{\link[DBI]{dbGetQuery}()},
\code{\link[DBI]{dbGetQueryArrow}()},
\code{\link[DBI]{dbIsReadOnly}()},
\code{\link[DBI]{dbIsValid}()},
\code{\link[DBI]{dbListFields}()},
\code{\link[DBI]{dbListObjects}()},
\code{\link[DBI]{dbListResults}()},
\code{\link[DBI]{dbListTables}()},
\code{\link[DBI]{dbQuoteIdentifier}()},
\code{\link[DBI]{dbReadTable}()},
\code{\link[DBI]{dbReadTableArrow}()},
\code{\link[DBI]{dbRemoveTable}()},
\code{\link[DBI]{dbSendQuery}()},
\code{\link[DBI]{dbSendQueryArrow}()},
\code{\link[DBI]{dbSendStatement}()},
\code{\link[DBI]{dbUnquoteIdentifier}()},
\code{\link[DBI]{dbWriteTable}()},
\code{\link[DBI]{dbWriteTableArrow}()}
}
