\name{analyze_disaster_sentiment}
\alias{analyze_disaster_sentiment}

\title{Analyze Disaster Sentiment}

\description{
It performs sentiment analysis on disaster-related text data using multiple methods.
}

\usage{
analyze_disaster_sentiment(data, text_column = "User_Comment", method = "afinn")
}
\arguments{
\item{data}{A data frame containing disaster data}

\item{text_column}{Name of the column containing text to analyze (default: "User_Comment")}

\item{method}{Sentiment analysis method: "afinn", "bing", "nrc", or "syuzhet" (default: "afinn")}
}
\value{
Data frame with added sentiment scores and categories.
}

\author{
Hossein Hassani and Leila Marvian Mashhad and Nadejda Komendantova.
}

\examples{
tweets_df <- data.frame(
  User_Comment = c(
    "The earthquake was terrible and scary",
    "Rescue teams are doing a wonderful job, I feel hopeful",
    "No damage here, everything feels normal"
  ),
  stringsAsFactors = FALSE
)
result_df <- analyze_disaster_sentiment(tweets_df, text_column = "User_Comment", method = "afinn")
print(result_df)
}




