% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_event_subscription.R
\name{delete_event_subscription}
\alias{delete_event_subscription}
\title{Delete event subscription}
\usage{
delete_event_subscription(subscriptionId, env = "production")
}
\arguments{
\item{subscriptionId}{(numeric) Event subscription identifier}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(logical) TRUE if the event subscription was deleted
}
\description{
Delete event subscription
}
\details{
After "deletion", the subscription might still exist in the
subscription database, but it will be inactive - it will not conflict with
future creation requests, it cannot be read, and it will not be notified of
events.
}
\note{
User authentication is required (see \code{login()})
}
\examples{
\dontrun{

login()

# Create subscription
subscriptionId <- create_event_subscription(
  packageId = "knb-lter-vcr.340.1",
  url = "https://my.webserver.org/",
  env = "staging"
)
subscriptionId
#> [1] 48

# Execute subscription
execute_event_subscription(
  subscriptionId = subscriptionId,
  env = "staging"
)
#> [1] TRUE

# Delete subscription
delete_event_subscription(subscriptionId, env = "staging")
#> [1] TRUE

logout()
}

}
\seealso{
Other Event Notifications: 
\code{\link{create_event_subscription}()},
\code{\link{execute_event_subscription}()},
\code{\link{get_event_subscription}()},
\code{\link{get_event_subscription_schema}()},
\code{\link{query_event_subscriptions}()}
}
\concept{Event Notifications}
