% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cr.evaluate.core.R
\name{cr.evaluate.core}
\alias{cr.evaluate.core}
\title{Coincidence Rate of Range}
\usage{
cr.evaluate.core(data, names, quantitative, selected)
}
\arguments{
\item{data}{The data as a data frame object. The data frame should possess
one row per individual and columns with the individual names and multiple
trait/character data.}

\item{names}{Name of column with the individual names as a character string.}

\item{quantitative}{Name of columns with the quantitative traits as a
character vector.}

\item{selected}{Character vector with the names of individuals selected in
core collection and present in the \code{names} column.}
}
\value{
The \mjseqn{CR} value.
}
\description{
Compute the following metrics to compare quantitative traits of the entire
collection (EC) and core set (CS). \itemize{\item{Coincidence Rate of Range
(\mjseqn{CR}) \insertCite{hu_methods_2000}{EvaluateCore} (originally
described by \insertCite{diwan_methods_1995}{EvaluateCore} as Mean range
ratio)} \item{Changeable Rate of Maximum (\mjseqn{CR_{\max}})
\insertCite{wang_assessment_2007}{EvaluateCore}} \item{Changeable Rate of
Minimum (\mjseqn{CR_{\min}}) \insertCite{wang_assessment_2007}{EvaluateCore}}
\item{Changeable Rate of Mean (\mjseqn{CR_{\mu}})
\insertCite{wang_assessment_2007}{EvaluateCore}} }
}
\details{
The Coincidence Rate of Range (\mjseqn{CR}) is computed as follows.

\mjsdeqn{CR = \left ( \frac{1}{n} \sum_{i=1}^{n}
\frac{R_{CS_{i}}}{R_{EC_{i}}} \right ) \times 100}

Where, \mjseqn{R_{CS_{i}}} is the range of the \mjseqn{i}th trait in the CS,
\mjseqn{R_{EC_{i}}} is the range of the \mjseqn{i}th trait in the EC and
\mjseqn{n} is the total number of traits.

A representative CS should have a \mjseqn{CR} value no less than 70\%
\insertCite{diwan_methods_1995}{EvaluateCore} or 80\%
\insertCite{hu_methods_2000}{EvaluateCore}.

The Changeable Rate of Maximum (\mjseqn{CR_{\max}}) is computed as follows.

\mjsdeqn{CR_{\max} = \left ( \frac{1}{n} \sum_{i=1}^{n}
\frac{\max_{CS_{i}}}{\max_{EC_{i}}} \right ) \times 100}

Where, \mjseqn{\max_{CS_{i}}} is the maximum value of the \mjseqn{i}th trait
in the CS, \mjseqn{\max_{EC_{i}}} is the maximum value of the \mjseqn{i}th
trait in the EC and \mjseqn{n} is the total number of traits.

The Changeable Rate of Minimum (\mjseqn{CR_{\min}}) is computed as follows.

\mjsdeqn{CR_{\min} = \left ( \frac{1}{n} \sum_{i=1}^{n}
\frac{\min_{CS_{i}}}{\min_{EC_{i}}} \right ) \times 100}

Where, \mjseqn{\min_{CS_{i}}} is the minimum value of the \mjseqn{i}th trait
in the CS, \mjseqn{\min_{EC_{i}}} is the minimum value of the \mjseqn{i}th
trait in the EC and \mjseqn{n} is the total number of traits.

The Changeable Rate of Mean (\mjseqn{CR_{\mu}}) is computed as follows.

\mjsdeqn{CR_{\mu} = \left ( \frac{1}{n} \sum_{i=1}^{n}
\frac{\mu_{CS_{i}}}{\mu_{EC_{i}}} \right ) \times 100}

Where, \mjseqn{\mu_{CS_{i}}} is the mean value of the \mjseqn{i}th trait in
the CS, \mjseqn{\mu_{EC_{i}}} is the mean value of the \mjseqn{i}th trait in
the EC and \mjseqn{n} is the total number of traits.
}
\note{
\code{NaN} or \code{Inf} values for \mjseqn{CR_{\min}} occurs when the
  minimum values for some of the traits are zero.
}
\examples{

data("cassava_CC")
data("cassava_EC")

ec <- cbind(genotypes = rownames(cassava_EC), cassava_EC)
ec$genotypes <- as.character(ec$genotypes)
rownames(ec) <- NULL

core <- rownames(cassava_CC)

quant <- c("NMSR", "TTRN", "TFWSR", "TTRW", "TFWSS", "TTSW", "TTPW", "AVPW",
           "ARSR", "SRDM")
qual <- c("CUAL", "LNGS", "PTLC", "DSTA", "LFRT", "LBTEF", "CBTR", "NMLB",
          "ANGB", "CUAL9M", "LVC9M", "TNPR9M", "PL9M", "STRP", "STRC",
          "PSTR")

ec[, qual] <- lapply(ec[, qual],
                     function(x) factor(as.factor(x)))

cr.evaluate.core(data = ec, names = "genotypes",
                 quantitative = quant, selected = core)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[stats]{wilcox.test}}
}
