% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{summarise_exposure}
\alias{summarise_exposure}
\title{Summarize Exposure to Mosquito Bites Over 24h and a Time Interval}
\usage{
summarise_exposure(data, interval = c(22, 5))
}
\arguments{
\item{data}{A dataframe returned by \code{calculate_Exp()}, including columns:
\itemize{
\item \code{Eui}, \code{Euo}, \code{Eu} – indoor, outdoor, and total exposure for non-users,
\item \code{Epi}, \code{Epn}, \code{Epo}, \code{Epp}, \code{Ep} – indoor, indoor under net, outdoor, prevented, and total exposure for users,
\item \code{hour} – hour of the day (0–23).
}}

\item{interval}{A numeric vector of length 2 giving the start and end hour (inclusive) of the time interval,
e.g., \code{c(22, 5)} for 10pm to 5am. Wraps over midnight if needed.}
}
\value{
A tibble with three columns:
\describe{
\item{type}{Character string indicating the category of summary: \code{"non_user_daily"}, \code{"user_daily"},
\code{"non_user_interval"}, \code{"user_interval"}, \code{"interval_vs_daily"} or \code{"net_efficacy"}.}
\item{output}{Name of the exposure component or metric (e.g., \code{"Eui"}, \code{"Euo"}, \code{"Ep"},
\code{"Epp"}, \code{"prop_indoor"}, etc., \code{"prop_interval_non_user"}, \code{"prop_interval_user"} and \code{"prop_prevented"}).}
\item{value}{Numeric value corresponding to the output for the given type.}
}
}
\description{
Computes daily (24h) and interval-specific exposure statistics for both non-users and bednet users,
based on the output of \code{\link{calculate_Exp}}. Protective efficacy of bednets
and proportion of exposure indoors or during the specified interval are computed.
}
\details{
The mathematical model of behavioral interactions is an extension of the \insertCite{killeenQuantifyingBehaviouralInteractions2006;textual}{ExpBites} model as previously described in \insertCite{geissbuhlerInterdependenceDomesticMalaria2007;textual}{ExpBites} and \insertCite{moirouxHumanExposureEarly2014;textual}{ExpBites}
}
\examples{
# generate fake data 
df <- gen_df_human(n_individuals = 100, hours = c(0:9,17:23))
df_bites <- gen_df_mosquito() 
# calculate mean hourly exposure to bites
exposure_results <- calculate_Exp(df, df_bites)
# summarise exposure estimates
summarise_exposure(exposure_results, interval = c(22, 5))

}
\references{
\insertAllCited{}
}
