% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TabulateSpecialValues.R
\name{TabulateSpecialValues}
\alias{TabulateSpecialValues}
\title{Tabulate special values often representing missing data}
\usage{
TabulateSpecialValues(DF, xVars = NULL, subsetIndex = NULL, dgts = 3)
}
\arguments{
\item{DF}{data frame containing all variables in the \code{xVars} list}

\item{xVars}{character vector of the names of variables to be examined
(default NULL means characterize all variables in data frame \code{DF})}

\item{subsetIndex}{index into record subset in \code{DF} to be examined
(default NULL means characterize all records in \code{DF})}

\item{dgts}{number of digits in frequency results (default = 3)}
}
\value{
data frame with one row for each variable in \code{xVars} list and
these columns:
\itemize{
\item Variable an element of the \code{xVars} list
\item nMiss number of records exhibiting the missing value NA (or NaN)
\item fracMiss fraction of records represented by \code{nMiss}
\item nBlank number of records listing the value blank (0 length character string)
\item fracBlank fraction of records represented by \code{nBlank}
\item nSpaces number of records consisting only of one or more spaces
\item fracSpaces fraction of records represented by \code{nSpaces}
\item nZero number of records listing the numerical value zero
\item fracZero fraction of records represented by `nZero'
\item nNeg number of records listing a negative numerical value
\item fracNeg fraction of records represented by \code{nNeg}
}
}
\description{
Generates a summary of counts and fractions of records from the
variables listed in \code{xVars} that are missing (using the standard R
designation NA), blank (0 length, common in character data),
spaces (one or more, also common in character data), and zeros
or negative values in numerical data (sometimes indicative of
range errors or disguised missing data)
}
\examples{
FirstAnomalyDataFrame
TabulateSpecialValues(FirstAnomalyDataFrame)
}
