% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qqplotEL.R
\name{qqplotEL}
\alias{qqplotEL}
\title{Quantile-Quantile Plot for the Extended Laplace Distribution}
\usage{
qqplotEL(sample_data, mu, sigma, delta)
}
\arguments{
\item{sample_data}{A numeric vector of sample data}

\item{mu}{Location parameter}

\item{sigma}{Scale parameter (must be > 0)}

\item{delta}{Uniform noise parameter (must be > 0)}
}
\value{
A Q-Q plot comparing sample data to the theoretical Extended Laplace distribution
}
\description{
Quantile-Quantile Plot for the Extended Laplace Distribution
}
\examples{
sample <- rEL(1000, mu = 0, sigma = 1, delta = 1)
qqplotEL(sample, mu = 0, sigma = 1, delta = 1)
}
