% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun_export.R
\name{set_bounds}
\alias{set_bounds}
\title{Set bounds for bounded forecast reconciliation}
\usage{
set_bounds(n, k, h, lb = -Inf, ub = Inf, approach = "osqp", bounds = NULL)
}
\arguments{
\item{n}{A (\eqn{b \times 1}) vector representing the \eqn{i}th cross-sectional
series (\eqn{i = 1, \dots, n}), where \eqn{b} is the number of bounds to be set.}

\item{k}{A (\eqn{b \times 1}) vector specifying the temporal aggregation orders
(\eqn{k = m, \dots, 1}).}

\item{h}{A (\eqn{b \times 1}) vector representing the forecast horizons
(\eqn{j = 1, \dots, m/k}).}

\item{lb, ub}{A (\eqn{b \times 1}) vector of lower and upper bounds.}

\item{approach}{A string specifying the algorithm to compute bounded reconciled forecasts:
\itemize{
\item "\code{osqp}": quadratic programming optimization
(\href{https://osqp.org/}{\pkg{osqp}} solver).
\item "\code{sftb}": heuristic "set-forecasts-to-bounds", which adjusts the reconciled
forecasts to be within specified bounds without further optimization.
}}

\item{bounds}{A matrix of previous bounds to be added. If not specified,
new bounds will be computed.}
}
\value{
A numeric matrix representing the computed bounds, which can be:
\itemize{
\item Cross-sectional (\eqn{b \times 3}) matrix for cross-sectional reconciliation (\link{csrec}).
\item Temporal (\eqn{b \times 4}) matrix for temporal reconciliation (\link{terec}).
\item Cross-temporal (\eqn{b \times 5}) matrix for cross-temporal reconciliation (\link{ctrec}).
}
}
\description{
This function defines the bounds matrix considering cross-sectional,
temporal, or cross-temporal frameworks. The output matrix can be used as
input for the \code{bounds} parameter in functions such as \link{csrec}, \link{terec},
or \link{ctrec}, to perform bounded reconciliations.
}
\examples{
# Example 1
# Two cross-sectional series (i = 2,3),
# with each series required to be between 0 and 1.
n <- c(2, 3)
lb <- c(0, 0)
ub <- c(1,1)
bounds_mat <- set_bounds(n = c(2, 3),
                         lb = rep(0, 2), # or lb = 0
                         ub = rep(1, 2)) # or ub = 1

# Example 2
# All the monthly values are between 0 and 1.
bounds_mat <- set_bounds(k = rep(1, 12),  # or k = 1
                         h = 1:12,
                         lb = rep(0, 12), # or lb = 0
                         ub = rep(1, 12)) # or ub = 1

# Example 3
# For two cross-sectional series (i = 2,3),
# all the monthly values are between 0 and 1.
bounds_mat <- set_bounds(n = rep(c(2, 3), each = 12),
                         k = 1,
                         h = rep(1:12, 2),
                         lb = 0, # or lb = 0
                         ub = 1) # or ub = 1

}
\seealso{
Utilities: 
\code{\link{FoReco2matrix}()},
\code{\link{aggts}()},
\code{\link{balance_hierarchy}()},
\code{\link{commat}()},
\code{\link{csprojmat}()},
\code{\link{cstools}()},
\code{\link{ctprojmat}()},
\code{\link{cttools}()},
\code{\link{df2aggmat}()},
\code{\link{lcmat}()},
\code{\link{recoinfo}()},
\code{\link{res2matrix}()},
\code{\link{shrink_estim}()},
\code{\link{shrink_oasd}()},
\code{\link{teprojmat}()},
\code{\link{tetools}()},
\code{\link{unbalance_hierarchy}()}
}
\concept{Utilities}
