% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_distance_matrix.R
\name{compute_distance_matrix}
\alias{compute_distance_matrix}
\title{Compute distance matrix}
\usage{
compute_distance_matrix(data, method = "euclidean", add.noise = FALSE)
}
\arguments{
\item{data}{A dataframe or matrix containing at least two numerical columns.}

\item{method}{method to compute the distance matrix. Ultimately passed to \code{\link[stats:dist]{stats::dist()}}. Can be \code{euclidean}, \code{maximum}, \code{manhattan}, \code{canberra}, \code{binary} or \code{minkowski}.}

\item{add.noise}{TRUE/FALSE set to TRUE to add a small noise to the distance matrix. Noise \eqn{U} is generated as \eqn{ U \sim (1\times 10^{-6}, 5\times 10^{-6})}.
Noise is added only for pairs for which distance is zero.}
}
\value{
a distance matrix, usable in \code{\link[=gwl_bw_estimation]{gwl_bw_estimation()}}
}
\description{
\code{compute_distance_matrix()} is a small helper function to help you compute a distance matrix.
For the geographically method to work, is is important that distances between points are not zero. This function allows to add a small random noise to avoid zero distances.
}
\examples{
coords <- data.frame("Lat" = rnorm(200), "Long" = rnorm(200))
distance_matrix <- compute_distance_matrix(coords)

}
