% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/principle_component_based_methods.R
\name{estimate_nuisance_pc}
\alias{estimate_nuisance_pc}
\title{The function for nuisance parameter estimation in simple_pc_testing() and debiased_pc_testing().}
\usage{
estimate_nuisance_pc(
  nuisance_sample_1,
  nuisance_sample_2 = NULL,
  pca_method = "sparse_pca",
  mean_method = "naive",
  num_latent_factor = 1,
  local_environment = NA
)
}
\arguments{
\item{nuisance_sample_1}{Group 1 sample. Each row is a subject and each column corresponds to a feature.}

\item{nuisance_sample_2}{Group 2 sample. Each row is a subject and each column corresponds to a feature.}

\item{pca_method}{Methods used to estimate principle component The default is "sparse_pca", using sparse PCA from package PMA. Other choices are "dense_pca"---the regular PCA; and "hard"--- hard-thresholding PCA, which also induces sparsity.}

\item{mean_method}{Methods used to estimate the mean vector. Default is sample mean "naive". There is also a hard-thresholding sparse estiamtor "hard".}

\item{num_latent_factor}{Number of principle to be estimated/tested. Default is 1.}

\item{local_environment}{A environment for hyperparameters shared between folds.}
}
\value{
A list of estimated nuisance quantities.
\item{estimate_leading_pc}{Leading principle components}
\item{estimate_mean_1}{Sample mean for group 1}
\item{estimate_mean_2}{Sample mean for group 1}
\item{estimate_eigenvalue}{Eigenvalue for each principle compoenent.}
\item{estimate_noise_variance}{Noise variance, I need this to construct block-diagonal estimates of the covariance matrix.}
}
\description{
The function for nuisance parameter estimation in simple_pc_testing() and debiased_pc_testing().
}
