% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_iblm_model.R
\name{check_iblm_model}
\alias{check_iblm_model}
\title{Check Object of Class `iblm`}
\usage{
check_iblm_model(model, booster_models_supported = c("xgb.Booster"))
}
\arguments{
\item{model}{Model object to validate, expected class "iblm"}

\item{booster_models_supported}{Booster model classes currently supported in the iblm package}
}
\value{
Invisible TRUE if all checks pass
}
\description{
Validates an iblm model object has required structure and features
}
\examples{
df_list <- freMTPLmini |> split_into_train_validate_test(seed = 9000)

iblm_model <- train_iblm_xgb(
  df_list,
  response_var = "ClaimRate",
  family = "poisson"
)

check_iblm_model(iblm_model)

}
