/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver;

import cern.colt.matrix.Norm;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.DenseFloatAlgebra;
import cern.colt.matrix.tfloat.algo.solver.AbstractFloatIterativeSolver;
import cern.colt.matrix.tfloat.algo.solver.FloatGivensRotation;
import cern.colt.matrix.tfloat.algo.solver.IterativeSolverFloatNotConvergedException;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix1D;
import cern.colt.matrix.tfloat.impl.DenseFloatMatrix2D;
import cern.jet.math.tfloat.FloatFunctions;

public class FloatGMRES
extends AbstractFloatIterativeSolver {
    private int restart;
    private FloatMatrix1D w;
    private FloatMatrix1D u;
    private FloatMatrix1D r;
    private FloatMatrix1D[] v;
    private FloatMatrix1D s;
    private FloatMatrix2D H;
    private FloatGivensRotation[] rotation;

    public FloatGMRES(FloatMatrix1D floatMatrix1D) {
        this(floatMatrix1D, 30);
    }

    public FloatGMRES(FloatMatrix1D floatMatrix1D, int n) {
        this.w = floatMatrix1D.copy();
        this.u = floatMatrix1D.copy();
        this.r = floatMatrix1D.copy();
        this.setRestart(n);
    }

    public void setRestart(int n) {
        this.restart = n;
        if (n <= 0) {
            throw new IllegalArgumentException("restart must be a positive integer");
        }
        this.s = new DenseFloatMatrix1D(n + 1);
        this.H = new DenseFloatMatrix2D(n + 1, n);
        this.rotation = new FloatGivensRotation[n + 1];
        this.v = new FloatMatrix1D[n + 1];
        for (int i = 0; i < this.v.length; ++i) {
            this.v[i] = new DenseFloatMatrix1D((int)this.r.size());
        }
    }

    public FloatMatrix1D solve(FloatMatrix2D floatMatrix2D, FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) throws IterativeSolverFloatNotConvergedException {
        this.checkSizes(floatMatrix2D, floatMatrix1D, floatMatrix1D2);
        floatMatrix2D.zMult(floatMatrix1D2, this.u.assign(floatMatrix1D), -1.0f, 1.0f, false);
        this.M.apply(this.u, this.r);
        float f = DenseFloatAlgebra.DEFAULT.norm(this.r, Norm.Two);
        this.M.apply(floatMatrix1D, this.u);
        this.iter.setFirst();
        while (!this.iter.converged(this.r, floatMatrix1D2)) {
            int n;
            int n2;
            this.v[0].assign(this.r, FloatFunctions.multSecond(1.0f / f));
            this.s.assign(0.0f).setQuick(0, f);
            for (n2 = 0; n2 < this.restart && !this.iter.converged(Math.abs(this.s.getQuick(n2))); ++n2) {
                floatMatrix2D.zMult(this.v[n2], this.u);
                this.M.apply(this.u, this.w);
                for (n = 0; n <= n2; ++n) {
                    this.H.setQuick(n, n2, this.w.zDotProduct(this.v[n]));
                    this.w.assign(this.v[n], FloatFunctions.plusMultSecond(-this.H.getQuick(n, n2)));
                }
                this.H.setQuick(n2 + 1, n2, DenseFloatAlgebra.DEFAULT.norm(this.w, Norm.Two));
                this.v[n2 + 1].assign(this.w, FloatFunctions.multSecond(1.0f / this.H.getQuick(n2 + 1, n2)));
                for (n = 0; n < n2; ++n) {
                    this.rotation[n].apply(this.H, n2, n, n + 1);
                }
                this.rotation[n2] = new FloatGivensRotation(this.H.getQuick(n2, n2), this.H.getQuick(n2 + 1, n2));
                this.rotation[n2].apply(this.H, n2, n2, n2 + 1);
                this.rotation[n2].apply(this.s, n2, n2 + 1);
                this.iter.next();
            }
            this.s = DenseFloatAlgebra.DEFAULT.backwardSolve(this.H.viewPart(0, 0, n2, n2), this.s);
            for (n = 0; n < n2; ++n) {
                floatMatrix1D2.assign(this.v[n], FloatFunctions.plusMultSecond(this.s.getQuick(n)));
            }
            floatMatrix2D.zMult(floatMatrix1D2, this.u.assign(floatMatrix1D), -1.0f, 1.0f, false);
            this.M.apply(this.u, this.r);
            f = DenseFloatAlgebra.DEFAULT.norm(this.r, Norm.Two);
            this.iter.next();
        }
        return floatMatrix1D2;
    }
}

