% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decoding_functions.R
\name{stateprobs_g}
\alias{stateprobs_g}
\title{Calculate conditional local state probabilities for inhomogeneous HMMs}
\usage{
stateprobs_g(delta, Gamma, allprobs, trackID = NULL, mod = NULL)
}
\arguments{
\item{delta}{initial or stationary distribution of length N, or matrix of dimension c(k,N) for k independent tracks, if \code{trackID} is provided}

\item{Gamma}{array of transition probability matrices of dimension c(N,N,n-1), as in a time series of length n, there are only n-1 transitions

If an array of dimension c(N,N,n) for a single track is provided, the first slice will be ignored.

If \code{trackID} is provided, \code{Gamma} needs to be an array of dimension c(N,N,n), where n is the number of rows in \code{allprobs}. Then for each track the first transition matrix will be ignored.}

\item{allprobs}{matrix of state-dependent probabilities/ density values of dimension c(n, N)}

\item{trackID}{optional vector of k track IDs, if multiple tracks need to be decoded separately}

\item{mod}{optional model object containing initial distribution \code{delta}, transition probability matrix \code{Gamma}, matrix of state-dependent probabilities \code{allprobs}, and potentially a \code{trackID} variable

If you are using automatic differentiation either with \code{RTMB::MakeADFun} or \code{\link{qreml}} and include \code{\link{forward_g}} in your likelihood function, the objects needed for state decoding are automatically reported after model fitting.
Hence, you can pass the model object obtained from running \code{RTMB::report()} or from \code{\link{qreml}} directly to this function.}
}
\value{
matrix of conditional state probabilities of dimension c(n,N)
}
\description{
Computes
\deqn{\Pr(S_t = j \mid X_1, ..., X_T)}
for inhomogeneous HMMs
}
\examples{
Gamma = tpm_g(runif(10), matrix(c(-1,-1,1,-2), nrow = 2, byrow = TRUE))
delta = c(0.5, 0.5)
allprobs = matrix(runif(20), nrow = 10, ncol = 2)

probs = stateprobs_g(delta, Gamma[,,-1], allprobs)
}
\seealso{
Other decoding functions: 
\code{\link{stateprobs}()},
\code{\link{stateprobs_p}()},
\code{\link{viterbi}()},
\code{\link{viterbi_g}()},
\code{\link{viterbi_p}()}
}
\concept{decoding functions}
