test_that("run_app errors with a clear message when app directory is missing", {
  expect_error(
    LifeTableFertility:::run_app(app_dir = ""),
    regexp = "Cannot find the 'shiny' app directory"
  )
})

test_that("run_app calls shiny::runApp when app directory exists", {
  tmp_app <- tempfile("appdir_")
  dir.create(tmp_app)
  
  called <- FALSE
  
  testthat::local_mocked_bindings(
    runApp = function(appDir, ...) {
      called <<- TRUE
      expect_equal(appDir, tmp_app)
      invisible(NULL)
    },
    .package = "shiny"
  )
  
  expect_silent(LifeTableFertility:::run_app(app_dir = tmp_app))
  expect_true(called)
})
