% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envlope.R
\name{envelope.MRM}
\alias{envelope.MRM}
\title{Compute simulation envelopes for MRM model}
\usage{
envelope.MRM(object, R = 100, ...)
}
\arguments{
\item{object}{An object of class \code{MRM}, typically returned from \code{\link{MRMfit}}.}

\item{R}{Integer. Number of replications to simulate the envelopes (default is 100).}

\item{...}{Additional arguments passed to \code{\link{MRMfit}} when \code{envelope = TRUE}.}
}
\value{
A QQ-plot with envelope.
}
\description{
This function computes the envelopes simulation of the randomized quantile residuals for objects of class \code{MRM}.
}
\examples{
\donttest{
data(Arthritis1)
fit <- MRMfit(y ~ Sex + Age + Treatment + Time, data = Arthritis1)
envelope.MRM(fit)
}

}
