% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keep.R
\name{keep}
\alias{keep}
\title{Save something to an object}
\usage{
keep(object, name, pos = 1, envir = as.environment(pos), inherits = FALSE)
}
\arguments{
\item{object}{the object that is to be saved into \code{name}.}

\item{name}{the name of the new object, containing the value of \code{object}.}

\item{pos}{where to do the assignment. See \code{?assign} for more details.}

\item{envir}{the environment to use. See \code{?assign} for more details.}

\item{inherits}{should the enclosing framss of the environment be inspected?
See \code{?assign} for more details.}
}
\value{
Upon saving \code{object} to \code{name}, the value of \code{object} is
returned. This makes it suitable for pipes.
}
\description{
\code{keep} saves an object to a new object. This is useful
if one wants to save an intermediate result when using pipes.
}
\examples{
mtcars |>
  lm(mpg ~  disp + hp, data = _) |>
  keep(lm.mpg_disp_hp) |>
  summary()
}
\author{
Mathijs Deen
}
