% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mic_manipulation.R
\name{fill_dilution_levels}
\alias{fill_dilution_levels}
\title{Fill MIC dilution levels}
\usage{
fill_dilution_levels(x, cap_upper = TRUE, cap_lower = TRUE, as.mic = TRUE)
}
\arguments{
\item{x}{MIC vector}

\item{cap_upper}{If True, will the top level will be the highest MIC dilution in x}

\item{cap_lower}{If True, will the bottom level will be the lowest MIC dilution in x}

\item{as.mic}{By default, returns an ordered factor. Set as.mic = TRUE to return as AMR::mic}
}
\value{
ordered factor (or AMR::mic if as.mic = TRUE)
}
\description{
Fill MIC dilution levels
}
\examples{
# use in combination with droplevels to clean up levels:
x <- AMR::as.mic(c("<0.25", "8", "64", ">64"))
x <- droplevels(x)
fill_dilution_levels(x)
}
