% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d_effect.R
\name{d_effect}
\alias{d_effect}
\title{General interface for Cohen's d}
\usage{
d_effect(
  m1 = NULL,
  m2 = NULL,
  sd1 = NULL,
  sd2 = NULL,
  u = NULL,
  sig = NULL,
  r = NULL,
  mdiff = NULL,
  sddiff = NULL,
  t_value = NULL,
  z_value = NULL,
  p1 = NULL,
  p2 = NULL,
  n1 = NULL,
  n2 = NULL,
  n = NULL,
  a = 0.05,
  design,
  ...
)
}
\arguments{
\item{m1}{Means of the two conditions or measurements.}

\item{m2}{Means of the two conditions or measurements.}

\item{sd1}{Standard deviations for the two conditions or measurements.}

\item{sd2}{Standard deviations for the two conditions or measurements.}

\item{u}{Population or comparison mean for one‑sample t‑designs,
used when `design = "single_t"`.}

\item{sig}{Population standard deviation for z-based designs, used when
`design = "z_mean"`.}

\item{r}{Correlation between the paired measurements (used for
repeated-measures designs such as `"dep_t_rm"`).}

\item{mdiff}{Mean difference between paired observations.}

\item{sddiff}{Standard deviation of the difference scores.}

\item{t_value}{t statistic value for the test. Used in designs where the
effect size is derived directly from a reported t-value (e.g.,
`"dep_t_diff_t"`, `"ind_t_t"`, or `"single_t_t"`).}

\item{z_value}{z statistic value for the test. Used in designs where the
effect size is derived directly from a reported z-value (e.g.,
`"z_z"`).}

\item{p1}{Proportion for group one (between 0 and 1), used in the
`"prop"` design.}

\item{p2}{Proportion for group two (between 0 and 1), used in the
`"prop"` design.}

\item{n1}{Sample sizes for the two independent groups (used for
independent-groups designs such as `"ind_t"`).}

\item{n2}{Sample sizes for the two independent groups (used for
independent-groups designs such as `"ind_t"`).}

\item{n}{Sample size (number of paired observations).}

\item{a}{Significance level used when computing confidence intervals.
Defaults to `0.05`.}

\item{design}{Character string specifying the study design.}

\item{...}{Reserved for future arguments and passed on to the underlying
helper functions when appropriate.}
}
\value{
A list with the same structure as returned by the underlying helper
function. For the current paired-means case, this is the output of
[d_dep_t_avg()], which includes:
\itemize{
  \item `d` – Cohen's d using the average SD denominator.
  \item `dlow`, `dhigh` – lower and upper confidence limits for `d`.
  \item Snake_case aliases such as `d_lower_limit` and `d_upper_limit`.
  \item Descriptive statistics (means, SDs, SEs, and their confidence
        limits) for each group.
}
}
\description{
`d_effect()` is a convenience wrapper that will route to the appropriate
Cohen's *d* helper function based on the arguments supplied. This allows
users to call a single function for different study designs while
maintaining backward compatibility with the more specific helpers.
}
\details{
- `"delta_ind_t"` — independent-groups t-test using the delta effect size,
  where the SD of group 1 is used as the denominator. Supply `m1`, `m2`,
  `sd1`, `sd2`, `n1`, and `n2`. In this case, `d_effect()` will call
  [delta.ind.t()] with the same arguments.

- `"g_ind_t"` — independent-groups t-test using Hedges' g, which applies
  a small-sample correction to the standardized mean difference. Supply
  `m1`, `m2`, `sd1`, `sd2`, `n1`, and `n2`. In this case, `d_effect()`
  will call [g_ind_t()] with the same arguments.

- `"z_z"` — one-sample z-test effect size where the *z* value is supplied
  directly along with the sample size `n`. Supply `z_value` and `n`. You
  may optionally supply `sig` (population SD) for descriptive reporting.
  In this case, `d_effect()` will call [d_z_z()] with the same arguments.
}
\section{Supported designs}{


- `"dep_t_avg"` — paired/dependent t-test with average SD denominator.
  Supply `m1`, `m2`, `sd1`, `sd2`, and `n`. In this case, `d()` will call
  [d_dep_t_avg()] with the same arguments.

- `"dep_t_diff"` — paired/dependent t-test using the
**SD of the difference scores**.
  Supply `mdiff`, `sddiff`, and `n`. In this case, `d()` will call
  [d_dep_t_diff()] with the same arguments.

- `"dep_t_diff_t"` — paired/dependent t-test where the
*t* value is supplied directly.
  Supply `t_value` and `n`. In this case, `d()` will call
  [d_dep_t_diff_t()] with the same arguments.

- `"dep_t_rm"` — paired/dependent t-test using the repeated-measures
  effect size \eqn{d_{rm}}, which adjusts for the correlation between
  measurements. Supply `m1`, `m2`, `sd1`, `sd2`, `r`, and `n`.
  In this case, `d()` will call [d_dep_t_rm()] with the same arguments.

- `"ind_t"` — independent-groups t-test using the pooled SD (\(d_s\)).
  Supply `m1`, `m2`, `sd1`, `sd2`, `n1`, and `n2`. In this case, `d()` will
  call [d_ind_t()] with the same arguments.

- `"ind_t_t"` — independent-groups t-test where the *t* value is supplied
  directly. Supply `t_value`, `n1`, and `n2`. In this case, `d()` will call
  [d_ind_t_t()] with the same arguments.

- `"g_ind_t"` — independent-groups t-test using Hedges' g, which applies
  a small-sample correction to the standardized mean difference. Supply
  `m1`, `m2`, `sd1`, `sd2`, `n1`, and `n2`. In this case, `d_effect()`
  will call [g_ind_t()] with the same arguments.

- `"single_t"` — one‑sample t‑test effect size using the sample mean,
  population mean, sample SD, and sample size. Supply `m1` (sample mean),
  `u` (population mean), `sd1`, and `n`. In this case, `d()` will call
  [d_single_t()] with the same arguments.

- `"single_t_t"` — one-sample t-test effect size where the *t* value is
  supplied directly along with the sample size `n`. In this case, `d()`
  will call [d_single_t_t()] with the same arguments.

- `"prop"` — independent proportions (binary outcome) using a
  standardized mean difference (SMD) that treats each proportion as the
  mean of a Bernoulli variable with pooled Bernoulli SD. Supply `p1`,
  `p2`, `n1`, and `n2`. In this case, `d()` will call [d_prop()] with
  the same arguments.

- `"prop_h"` — independent proportions (binary outcome) using Cohen's
  \(h\) based on the arcsine-transformed difference between proportions.
  Supply `p1`, `p2`, `n1`, and `n2`. In this case, `d()` will call
  [h_prop()] with the same arguments.

- `"z_mean"` — one-sample z-test effect size using a known population
  standard deviation. Supply `m1` (sample mean), `u` (population mean),
  `sd1` (sample SD, used for descriptive CIs), `sig` (population SD),
  and `n`. In this case, `d_effect()` will call [d_z_mean()] with the
  same arguments.
}

\examples{
# Paired/dependent t-test using average SD denominator
# These arguments will route d() to d_dep_t_avg()
d_effect(
  m1 = 5.57, m2 = 4.43,
  sd1 = 1.99, sd2 = 2.88,
  n = 7, a = .05,
  design = "dep_t_avg"
)

# You can also call the helper directly
d_dep_t_avg(
  m1 = 5.57, m2 = 4.43,
  sd1 = 1.99, sd2 = 2.88,
  n = 7, a = .05
)

}
