% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CCA_algorithm.R
\name{cscca}
\alias{cscca}
\title{Compositional Sparse Canonical Correlation Analysis}
\usage{
cscca(
  Y,
  View.ind,
  lambda.seq,
  a.old = NULL,
  View.type = NULL,
  eps.stop = 1e-04,
  max.step = 30,
  eps = 1e-04,
  T.step = 1
)
}
\arguments{
\item{Y}{a n*(K*p) matrix representing the observations.}

\item{View.ind}{a (K*p) integer vector indicating the classes of features. The features with the same View.ind is in the same class.}

\item{lambda.seq}{a K vector consisting of hyper-parameters.}

\item{a.old}{Optional initial value for the coefficient vector \code{a.new}.}

\item{View.type}{a K vector encoding the structure type of each feature class. There are two choices: "O" (Omics Data),"C" (Compositional Data).}

\item{eps.stop}{a numerical value controlling the convergence.}

\item{max.step}{an integer controlling the maximum step for interaction.}

\item{eps}{a numerical value controlling the convergence.}

\item{T.step}{an integer controlling the maximum step for interaction.}
}
\value{
\code{a.new} the estimated coefficient vector.
}
\description{
A compositional sparse canonical correlation analysis (csCCA) framework for integrating microbiome data with other high-dimensional omics data.
}
\examples{
\dontrun{
library(dplyr)

n <- 200
p <- q <- 100
sigma.nu <- 5
sigma.eps <- 1
omega_X <- 0.85*c(rep(1/10,9),-9/10,rep(0,p-10))
omega_Y <- 0.85*c(seq(0.08,0.12,length = 10),rep(0,q-10))
Data1 <- DGP_OC(seed=10,n,p,q,sigma.nu,sigma.eps,omega_X,omega_Y)

library(mlrMBO)
Res.sCCA.CV <- cscca.CV(Y=Data1$Y,View.ind=Data1$View.ind,
                          View.type=c("O","O"),
                          show.info = TRUE)


Res.CsCCA.CV <- cscca.CV(Y=Data1$Y,View.ind=Data1$View.ind,
                                   View.type=c("O","C"),
                                   show.info = TRUE)

Res.sCCA <- cscca(Y=Data1$Y,View.ind=Data1$View.ind,
                     lambda.seq=Res.sCCA.CV$lam.opt.trgt,
                     View.type=c("O","O"))
Res.CsCCA <- cscca(Y=Data1$Y,View.ind=Data1$View.ind,
                     lambda.seq=Res.CsCCA.CV$lam.opt.trgt,
                     View.type=c("O","C"))
   }
}
\references{
1. Deng, L., Tang, Y., Zhang, X., et al. (2024). Structure-adaptive canonical correlation analysis for microbiome multi-omics data. Frontiers in Genetics, 15, 1489694.

2. Chen, J., Bushman, F. D., Lewis, J. D., et al. (2013). Structure-constrained sparse canonical correlation analysis with an application to microbiome data analysis. Biostatistics, 14(2), 244–258.
}
