% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outputConnectivity.R
\name{plot.intrinsicAssign}
\alias{plot.intrinsicAssign}
\title{Basic plot function for the different isoAssign outputs}
\usage{
\method{plot}{intrinsicAssign}(x, map, ...)
}
\arguments{
\item{x}{an isoAssign object}

\item{map}{which \code{isoAssign} output to plot either 'probability', 'population' or 'odds'}

\item{...}{additional arguments passed to plot function}
}
\value{
No return value, called to generate plot(s).
}
\description{
Generates a basic plot of the isotope assignments. If
\code{map = 'population'} generates a single map. If
\code{map = 'probability' or map = 'odds'} generates a map for each
individual is generated. User is asked for input before each individual is
drawn.
}
\examples{
\donttest{
  extensions <- c("shp", "shx", "dbf", "sbn", "sbx")
  tmp <- tempdir()
  for (ext in extensions) {
  download.file(paste0(
              "https://raw.githubusercontent.com/SMBC-NZP/MigConnectivity",
                     "/master/data-raw/Spatial_Layers/OVENdist.",
                     ext),
              destfile = paste0(tmp, "/OVENdist.", ext), mode = "wb")
  }
  OVENdist <- sf::st_read(paste0(tmp, "/OVENdist.shp"))
  OVENdist <- OVENdist[OVENdist$ORIGIN==2,] # only breeding
  sf::st_crs(OVENdist) <- sf::st_crs(4326)

  download.file(paste0(
    "https://raw.githubusercontent.com/SMBC-NZP/MigConnectivity",
                     "/master/data-raw/deltaDvalues.csv"),
              destfile = paste0(tmp, "/deltaDvalues.csv"))
  OVENvals <- read.csv(paste0(tmp, "/deltaDvalues.csv"))

  b <- isoAssign(isovalues = OVENvals[,2],
                 isoSTD = 12,
                 intercept = -10,
                 slope = 0.8,
                 odds = NULL,
                 restrict2Likely = TRUE,
                 nSamples = 1000,
                 sppShapefile = OVENdist,
                 assignExtent = c(-179,-60,15,89),
                 element = "Hydrogen",
                 period = "GrowingSeason") # setting for demonstration only

  plot(b, map = "population")
}

}
\seealso{
{\code{isoAssign}}
}
