% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simConnectivity.R
\name{simGLData}
\alias{simGLData}
\title{Simulate geolocator (GL) migratory movement data}
\usage{
simGLData(
  psi,
  originRelAbund = NULL,
  sampleSize,
  originSites = NULL,
  targetSites = NULL,
  geoBias = NULL,
  geoVCov = NULL,
  geoBiasOrigin = geoBias,
  geoVCovOrigin = geoVCov,
  S = 1,
  p = list(1, 1),
  requireEveryOrigin = FALSE
)
}
\arguments{
\item{psi}{Transition probabilities between B origin and W target sites.
A matrix with B rows and W columns where rows sum to 1.}

\item{originRelAbund}{Relative abundances at B origin sites. Numeric vector
of length B that sums to 1.}

\item{sampleSize}{List of length two. The first element is either a vector of
length B with the number of simulated animals to release with geolocators
at each of the B origin sites, a single integer with the total number of
simulated animals to release with geolocators at origin sites (in which
case, the origin sites will be sampled according to the relative
abundance), or NULL if all animals are released at target sites. The
second element is either a vector of length W with the number of simulated
animals to release with geolocators at each of the W target sites, a
single integer with the total number of simulated animals to release with
geolocators at target sites (in which case, the target sites will be
sampled according to their relative abundance), or NULL if all animals are
released at origin sites.}

\item{originSites}{A polygon spatial layer (sf - MULTIPOLYGON) defining the
geographic representation of sites in the origin season.}

\item{targetSites}{A polygon spatial layer (sf - MULTIPOLYGON) defining the
geographic representation of sites in the target season.}

\item{geoBias}{Vector of length 2 indicating expected bias in longitude and
latitude of animals captured and released at origin sites, in
\code{targetSites} units.}

\item{geoVCov}{2x2 matrix with expected variance/covariance in longitude and
latitude of animals captured and released at origin sites, in
\code{targetSites} units.}

\item{geoBiasOrigin}{Vector of length 2 indicating expected bias in longitude
and latitude of animals captured and released at target sites, in
\code{originSites} units.}

\item{geoVCovOrigin}{2x2 matrix with expected variance/covariance in
longitude and latitude of animals captured and released at target sites,
in \code{originSites} units.}

\item{S}{Survival probabilities of released geolocator animals. Either a
matrix with B rows and W columns (if survival depends on both origin site
and target site), a vector of length W (if survival depends only on target
site), or a single number (if survival is the same for all animals).
Default 1 (all animals with geolocators survive a year).}

\item{p}{Recapture probabilities of released geolocator animals; list of
length two. The first element is either a vector of length B (if recapture
depends on origin site), or a single number (if recapture is the same for
all animals released on origin sites). The second element is either a
vector of length W (if recapture depends on target site), or a single
number (if recapture is the same for all animals released on target
sites). Default list(1, 1) (all animals that survive are recaptured).}

\item{requireEveryOrigin}{If TRUE, the function will throw an error if it
looks like at least one origin site has no animals released in or
migrating to it, or if it can, keep simulating until representation is
met. This helps estTransition or estMC not throw an error. Default FALSE.}
}
\value{
\code{simGLData} returns a list with the elements:
\describe{
  \item{\code{originAssignment}}{Vector with true origin site of each animal}
  \item{\code{targetAssignment}}{Vector with true target site of each animal}
  \item{\code{originPointsTrue}}{True origin location of each animal, type sf,
   same projection as originSites}
  \item{\code{targetPointsTrue}}{True target location of each animal, type sf,
   same projection as targetSites}
  \item{\code{originPointsObs}}{Observed origin location of each animal that
   survived and was recaptured, type sf, same projection as originSites. Same
   as originPointsTrue for animals captured at origin sites when S and p==1}
  \item{\code{targetPointsObs}}{Observed target location of each animal that
   survived and was recaptured, type sf, same projection as targetSites. Same
   as targetPointsTrue for animals captured at target sites when S and p==1}
  \item{\code{lived}}{0/1 vector for each animal, indicating which survived}
  \item{\code{recaptured}}{0/1 vector for each animal, indicating which were
   recaptured}
  \item{\code{input}}{List containing the inputs to function}
}
}
\description{
Simulate geolocator (GL) migratory movement data
}
