% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{biplot_pq}
\alias{biplot_pq}
\title{Visualization of two samples for comparison}
\usage{
biplot_pq(
  physeq,
  fact = NULL,
  merge_sample_by = NULL,
  rarefy_after_merging = FALSE,
  inverse_side = FALSE,
  left_name = NULL,
  left_name_col = "#4B3E1E",
  left_fill = "#4B3E1E",
  left_col = "#f3f2d9",
  right_name = NULL,
  right_name_col = "#1d2949",
  right_fill = "#1d2949",
  right_col = "#1d2949",
  log10trans = TRUE,
  nudge_y = c(0.3, 0.3),
  geom_label = FALSE,
  text_size = 3,
  size_names = 5,
  y_names = NA,
  ylim_modif = c(1, 1),
  nb_samples_info = TRUE,
  plotly_version = FALSE,
  ...
)
}
\arguments{
\item{physeq}{(required) a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{fact}{(default: NULL) Name of the factor in \code{physeq@sam_data}.
If left to NULL use the \code{left_name} and \code{right_name} parameter as modality.}

\item{merge_sample_by}{(default: NULL) if not \code{NULL} samples of
physeq are merged using the vector set by \code{merge_sample_by}. This
merging used the \code{\link[=merge_samples2]{merge_samples2()}}. In the case of
\code{\link[=biplot_pq]{biplot_pq()}} this must be a factor with two levels only.}

\item{rarefy_after_merging}{Rarefy each sample after merging by the
modalities merge_sample_by}

\item{inverse_side}{Inverse the side (put the right modality in the left side).}

\item{left_name}{Name fo the left sample.}

\item{left_name_col}{Color for the left name}

\item{left_fill}{Fill fo the left sample.}

\item{left_col}{Color fo the left sample.}

\item{right_name}{Name fo the right sample.}

\item{right_name_col}{Color for the right name}

\item{right_fill}{Fill fo the right sample.}

\item{right_col}{Color fo the right sample.}

\item{log10trans}{(logical) Does abundancy is log10 transformed ?}

\item{nudge_y}{A parameter to control the y position of abundancy values.
If a vector of two values are set. The first value is for the left side.
and the second value for the right one. If one value is set,
this value is used for both side.}

\item{geom_label}{(default: FALSE, logical) if TRUE use the \code{\link[ggplot2:geom_text]{ggplot2::geom_label()}} function
instead of \code{\link[ggplot2:geom_text]{ggplot2::geom_text()}} to indicate the numbers of sequences.}

\item{text_size}{size for the number of sequences}

\item{size_names}{size for the names of the 2 samples}

\item{y_names}{y position for the names of the 2 samples. If NA (default),
computed using the maximum abundances values.}

\item{ylim_modif}{vector of two values. Modificator (by a multiplication)
of ylim. If one value is set, this value is used for both limits.}

\item{nb_samples_info}{(default: TRUE, logical) if TRUE and merge_sample_by is set,
add the number of samples merged for both levels.}

\item{plotly_version}{If TRUE, use \code{\link[plotly:ggplotly]{plotly::ggplotly()}} to return
a interactive ggplot.}

\item{...}{Other arguments for the ggplot function}
}
\value{
A plot
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-maturing-blue" alt="lifecycle-maturing"></a>
}}


Graphical representation of distribution of taxa across two samples.
}
\examples{
data_fungi_2Height <- subset_samples(data_fungi_mini, Height \%in\% c("Low", "High"))
biplot_pq(data_fungi_2Height, "Height", merge_sample_by = "Height")
}
\author{
Adrien Taudière
}
