% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Inference.R
\name{discreteStatesFromBN}
\alias{discreteStatesFromBN}
\title{Get the states of all discrete nodes from a MoTFB-BN}
\usage{
discreteStatesFromBN(bn, dag)
}
\arguments{
\item{bn}{A list of lists obtained from \link{MoTBFs_Learning}.}

\item{dag}{A network of class \code{"bn"}.}
}
\value{
\code{discreteStatesFromBN} returns a list of length equal to the number of discrete nodes in the network. Each element of the list corresponds to a node and contains a character vector indicating the states of the node.
}
\description{
This function returns the states of all discrete nodes from a list obtained from \link{MoTBFs_Learning}.
}
\examples{

## Create a dataset
  # Continuous variables
  x <- rnorm(100)
  y <- rnorm(100)
  
  # Discrete variable
  z <- sample(letters[1:2],size = 100, replace = TRUE)
  
  data <- data.frame(C1 = x, C2 = y, D1 = z, stringsAsFactors = FALSE)
  
## Get DAG
  dag <- LearningHC(data)

## Learn a BN
  bn <- MoTBFs_Learning(dag, data, POTENTIAL_TYPE = "MTE")

## Get the states of the discrete nodes

  discreteStatesFromBN(bn, dag)
}
