% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NPT_continuous.R
\name{NPT_continuous}
\alias{NPT_continuous}
\title{Continuous Niche Classification Based on Periodic Table of Niches}
\usage{
NPT_continuous(data, dimension)
}
\arguments{
\item{data}{A data frame containing species and their functional trait measurements.
Each row represents a species and columns contain trait values. The data should
include all traits specified in the dimension parameter.}

\item{dimension}{A named list where each element represents a niche dimension
(e.g., "grow", "survive", "reproductive") and contains a character vector of
column names corresponding to traits associated with that dimension. Each
dimension should contain multiple functionally related traits.}
}
\value{
A list containing three elements:
\item{PCA_first}{A data frame summarizing the first-level PCA results for each
dimension, including variance explained by PC1 and PC2 (as percentages), and
the traits with highest absolute loadings on each principal component axis}
\item{PCA_second}{A matrix containing species scores from the second-level PCA
that integrates all niche dimensions into a unified ordination space}
\item{result}{The complete second-level PCA result object from vegan::rda()
containing detailed ordination results for further analysis}
}
\description{
This function implements a continuous niche classification scheme based on the
periodic table of niches concept. It performs a hierarchical Principal Component
Analysis (PCA) approach where separate PCAs are conducted on different niche
dimensions, followed by a second-level PCA to integrate results across dimensions.
}
\details{
The function implements a two-stage hierarchical PCA approach based on the
methodology described in Winemiller et al. (2015) for creating continuous niche
classification schemes. This approach addresses the challenge that analysis of
data sets containing many functionally unrelated measures may fail to detect
patterns of covariation that determine species' ecological responses to and
effects on their environments.

\strong{Stage 1: Dimensional PCA Analysis}

Separate Principal Component Analysis is performed on trait data for each niche
dimension using the internal \code{pca_first} function. This dimensional approach
ensures that all niche dimensions have an equal opportunity to influence the
composite niche scheme and species ordinations. For each dimension, the function:
\itemize{
\item Performs PCA using \code{vegan::rda()}
\item Calculates variance explained by the first two principal components
\item Identifies traits with highest absolute loadings on PC1 and PC2
\item Extracts species scores on both principal components
}

\strong{Stage 2: Integration PCA}

The species scores from the first two principal components of each dimensional
PCA are combined into a new data matrix (with columns named as "pc1.dimension"
and "pc2.dimension"). A second PCA is then performed on this matrix to create
a two-dimensional continuum integrating patterns (strategies) within each of
the niche dimensions. This creates a continuous ordination of species within
niche space that can be used for comparative ecological analyses.

\strong{Methodological Advantages}

This hierarchical PCA method prevents domination by any single type of trait
or dimension. The approach allows all niche dimensions to have equal influence
on the composite niche scheme, with gradients dominated by those dimensional
components having greatest influence on community structure patterns.
}
\note{
\strong{Important Considerations:}
\itemize{
\item Missing values (NA) are automatically removed using \code{na.omit()}
\item A message displays the number of rows removed due to NA values
\item Each niche dimension should contain multiple functionally related traits
\item Users should ensure traits are appropriately scaled/transformed before analysis
\item The function uses scaling = FALSE in PCA, assuming pre-standardized data
\item Column names in the data must exactly match trait names in dimensions list
}
}
\examples{
data(PFF)
PFF[,4:21] <- log(PFF[,4:21])
traits_dimension <- list(
  grow = c("SLA","SRL","Leaf_Nmass","Root_Nmass"),
  survive = c("Height","Leaf_CN","Root_CN"),
  reproductive = c("SeedMass","FltDate","FltDur")
)
result <- NPT_continuous(data = PFF, dimension = traits_dimension)
result

}
\references{
\enumerate{
\item Winemiller, K. O., Fitzgerald, D. B., Bower, L. M., & Pianka, E. R. (2015). Functional traits,
convergent evolution, and periodic tables of niches. Ecology letters, 18(8), 737-751.
\item Yu, R., Huang, J., Xu, Y., Ding, Y., & Zang, R. (2020). Plant functional niches in forests across four climatic zones:
Exploring the periodic table of niches based on plant functional traits. Frontiers in Plant Science, 11, 841.
}
}
