% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_est_binder.R
\name{cluster_est_binder}
\alias{cluster_est_binder}
\title{Point estimate of the partition for the Binder loss function}
\usage{
cluster_est_binder(c, logposterior)
}
\arguments{
\item{c}{a list of vector of length \code{n}. \code{c[[j]][i]} is
the cluster allocation of observation \code{i=1...n} at iteration
\code{j=1...N}.}

\item{logposterior}{vector of logposterior corresponding to each
partition from \code{c} used to break ties when minimizing the cost function}
}
\value{
a \code{list}:
 \describe{
     \item{\code{c_est}:}{ a vector of length \code{n}. Point estimate of the partition}
     \item{\code{cost}:}{ a vector of length \code{N}. \code{cost[j]} is the cost
     associated to partition \code{c[[j]]}}
     \item{\code{similarity}:}{  matrix of size \code{n x n}. Similarity matrix
     (see \code{\link{similarityMat}})}
     \item{\code{opt_ind}:}{ the index of the optimal partition
     among the MCMC iterations.}
 }
}
\description{
Get a point estimate of the partition using the Binder loss function.
}
\references{
F Caron, YW Teh, TB Murphy, Bayesian nonparametric Plackett-Luce
models for the analysis of preferences for college degree programmes,
\emph{Annals of Applied Statistics}, 8(2):1145-1181, 2014.

DB Dahl, Model-Based Clustering for Expression Data via a
Dirichlet Process Mixture Model, \emph{Bayesian Inference for
Gene Expression and Proteomics}, K-A Do, P Muller, M Vannucci
(Eds.), Cambridge University Press, 2006.
}
\seealso{
\code{\link{similarityMat}} \code{\link{similarityMatC}}
}
\author{
Francois Caron, Boris Hejblum
}
