#' Calculate N Utilization Efficiency (NUtE)
#' @description
#' The contribution of fertilizer N from the plant tissues towards the yield component.
#' Formula: NUtE = Yield / PlantN
#' @param Yield A numeric vector of yield values.
#' @param PlantN A numeric vector for plant tissue N.
#' @return A numeric vector of NUtE values.
#' @examples
#' Yield <- c(10, 12, 15)
#' PlantN <- c(2.5, 3.0, 3.2)
#' NUtE(Yield, PlantN)
#' @export
NUtE <- function(Yield, PlantN) {
  return(Yield / PlantN)
}