% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MvtF.R
\name{MvtF}
\alias{MvtF}
\alias{dmvf}
\alias{pmvf}
\alias{qmvf}
\alias{rmvf}
\alias{smvf}
\title{Multivariate F Distribution}
\usage{
dmvf(x, df = rep(1, k + 1), log = FALSE)

pmvf(q, df = rep(1, k + 1), algorithm = c("numerical", "MC"), nsim = 1e+07)

qmvf(
  p,
  df = rep(1, k + 1),
  interval = c(1e-08, 1e+08),
  algorithm = c("numerical", "MC"),
  nsim = 1e+06
)

rmvf(n, df = rep(1, k + 1))

smvf(q, df = rep(1, k + 1), algorithm = c("numerical", "MC"), nsim = 1e+07)
}
\arguments{
\item{x}{vector or matrix of quantiles. If \eqn{x} is a matrix, each row vector constitutes a vector of quantiles for which the density \eqn{f(x)} is calculated (for \eqn{i}-th row \eqn{x_i}, \eqn{f(x_i)} is reported).}

\item{df}{a vector of \eqn{k+1} degrees of freedom, see parameter \eqn{(2a, 2l_1, \ldots, 2l_k)} in \strong{Details}.}

\item{log}{logical; if TRUE, probability densities \eqn{f} are given as \eqn{log(f)}.}

\item{q}{a vector of quantiles.}

\item{algorithm}{method to be used for calculating cumulative probability. Two options are provided as (i) \code{numerical} using adaptive multivariate integral and (ii) \code{MC} using Monte Carlo method. Recommend algorithm \code{numerical} for \eqn{(k <= 4)} dimension and \code{MC} for \eqn{(k > 4)} dimension based on running time consumption. Default option is set as \code{numerical}.}

\item{nsim}{number of simulations used in algorithm \code{MC}.}

\item{p}{a scalar value corresponding to probability.}

\item{interval}{a vector containing the end-points of the interval to be searched. Default value is set as \code{c(1e-8, 1e8)}.}

\item{n}{number of observations.}

\item{k}{dimension of data or number of variates.}
}
\value{
\code{dmvf} gives the numerical values of the probability density.

\code{pmvf} gives a list of two items:

\eqn{\quad} \code{value} cumulative probability

\eqn{\quad} \code{error} the estimated relative error by \code{algorithm = "numerical"} or the estimated standard error by \code{algorithm = "MC"}

\code{qmvf} gives the equicoordinate quantile. \code{NaN} is returned for no solution found in the given interval. The result is seed dependent if Monte Carlo algorithm is chosen  (\code{algorithm = "MC"}).

\code{rmvf} generates random numbers.

\code{smvf} gives a list of two items:

\eqn{\quad} \code{value} the value of survial function

\eqn{\quad} \code{error} the estimated relative error by \code{algorithm = "numerical"} or the estimated standard error by \code{algorithm = "MC"}
}
\description{
Calculation of density function, cumulative distribution function, equicoordinate quantile function and survival function, and random numbers generation for multivariate \eqn{F} distribution with degrees of freedom \code{df}.
}
\details{
Multivariate \eqn{F} distribution (Johnson and Kotz, 1972) is a joint probability distribution of positive random variables and its probability density is given as
\deqn{f(x_1, \cdots, x_k) = \frac{[ \prod_{i=1}^{k} (l_i/a)^{l_i}] \Gamma(\sum_{i=1}^{k} l_i + a) \prod_{i=1}^{k} x_i^{l_i-1}}{\Gamma(a) [ \prod_{i=1}^{k} \Gamma(l_i)] (1+\sum_{i=1}^{k} \frac{l_i}{a}x_i )^{\sum_{i=1}^{k} l_i + a}},}
where \eqn{x_i>0, a>0, l_i>0, i=1,\cdots, k}. The degrees of freedom are \eqn{(2a, 2l_1,\dots,2l_k)}.

Cumulative distribution function \eqn{F(x_1, \dots, x_k)} is obtained by multiple integral
\deqn{F(x_1, \dots, x_k) = \int_{0}^{x_1} \cdots  \int_{0}^{x_k} f(y_1, \cdots, y_k) dy_k \cdots dy_1.}
This multiple integral is calculated by either adaptive multivariate integration using \code{\link[cubature]{hcubature}} in package \strong{\link[cubature]{cubature}} (Narasimhan et al., 2018) or via Monte Carlo method.

Equicoordinate quantile is obtained by solving the following equation for \eqn{q} through the built-in one dimension root finding function \code{\link{uniroot}}:
\deqn{\int_{0}^{q} \cdots \int_{0}^{q} f(x_1, \cdots, x_k) dx_k \cdots dx_1 = p,}
where \eqn{p} is the given cumulative probability.

The survival function \eqn{\bar{F}(x_1, \cdots, x_k)} is obtained either by the following formula related to cumulative distribution function \eqn{F(x_1, \dots, x_k)} (Joe, 1997)
\deqn{\bar{F}(x_1, \cdots, x_k) = 1 + \sum_{S \in \mathcal{S}} (-1)^{|S|} F_S(x_j, j \in S),}
or via Monte Carlo method.

Random numbers \eqn{X_1, \cdots, X_k} from multivariate F distribution can be generated through parameter substitutions in simulation of generalized multivariate Lomax distribution by letting \eqn{\theta_i = l_i/a, i = 1, \cdots, k}; see Nayak (1987).
}
\examples{
# Calculations for the multivariate F with degrees of freedom:
# df = c(2, 4, 6)
# Vector of quantiles:  c(1, 2)

dmvf(x = c(1, 2), df = c(2, 4, 6)) # Density

# Cumulative Probability using adaptive multivariate integral
pmvf(q = c(1, 2), df = c(2, 4, 6), algorithm = "numerical")

\donttest{
# Cumulative Probability using Monte Carlo method
pmvf(q = c(1, 2), df = c(2, 4, 6), algorithm = "MC")}

\donttest{
# Equicoordinate quantile of cumulative probability 0.5
qmvf(p = 0.5, df = c(2, 4, 6))}

# Random numbers generation with sample size 100
rmvf(n = 100, df = c(2, 4, 6))

smvf(q = c(1, 2), df = c(2, 4, 6)) # Survival function

}
\references{
Joe, H. (1997). \emph{Multivariate Models and Dependence Concepts}. London: Chapman & Hall.

Johnson, N. L. and Kotz, S. (1972). \emph{Distribution in Statistics: Continuous Multivariate Distributions}. New York: John Wiley & Sons, INC.

Narasimhan, B.,  Koller, M., Johnson, S. G., Hahn, T., Bouvier, A., Kiêu, K. and Gaure, S. (2018). cubature: Adaptive Multivariate Integration over Hypercubes. R package version 2.0.3.

Nayak, T. K. (1987). Multivariate Lomax Distribution: Properties and Usefulness in Reliability Theory. \emph{Journal of Applied Probability}, Vol. 24, No. 1, 170-177.
}
\seealso{
\code{\link{uniroot}} for one dimensional root (zero) finding.
}
