% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phosphate_availability.R
\name{calc_phosphate_availability}
\alias{calc_phosphate_availability}
\title{Calculate the phosphate availability (PBI)}
\usage{
calc_phosphate_availability(
  B_LU_BRP,
  A_P_AL = NULL,
  A_P_CC = NULL,
  A_P_WA = NULL
)
}
\arguments{
\item{B_LU_BRP}{(numeric) The crop code from the BRP}

\item{A_P_AL}{(numeric) The P-AL content of the soil}

\item{A_P_CC}{(numeric) The P-CaCl2 content of the soil}

\item{A_P_WA}{(numeric) The P-content of the soil extracted with water}
}
\value{
The phosphate availability index estimated from extractable soil P fractions. A numeric value.
}
\description{
This function calculates the phosphate availability. This value can be evaluated by \code{\link{ind_phosphate_availability}}
}
\examples{
calc_phosphate_availability(B_LU_BRP = 265, A_P_AL = 45, A_P_CC = 2.5)
calc_phosphate_availability(c(265,1019),A_P_AL = c(35,54),A_P_CC = c(2.5,4.5), A_P_WA = c(35,65))

}
