% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_ODRF.R
\name{predict.ODRF}
\alias{predict.ODRF}
\title{predict based on an ODRF object}
\usage{
\method{predict}{ODRF}(object, Xnew, type = "response", weight.tree = FALSE, ...)
}
\arguments{
\item{object}{An object of class ODRF, the same created by the function \code{\link{ODRF}}.}

\item{Xnew}{An n by d numeric matrix (preferable) or data frame. The rows correspond to observations and columns correspond to features.
Note that if there are NA values in the data 'Xnew', which will be replaced with the average value.}

\item{type}{One of \code{response}, \code{prob} or \code{tree}, indicating the type of output: predicted values, matrix of class probabilities or predicted value for each tree.}

\item{weight.tree}{Whether to weight the tree, if \code{TRUE} then use the out-of-bag error of the tree as the weight. (default \code{FALSE})}

\item{...}{Arguments to be passed to methods.}
}
\value{
A set of vectors in the following list:
\itemize{
\item \code{response}: the predicted values of the new data.
\item \code{prob}: matrix of class probabilities (one column for each class and one row for each input). If \code{object$split} is \code{mse}, a vector of tree weights is returned.
\item \code{tree}: It is a matrix where each column is a prediction for each tree.
}
}
\description{
Prediction of ODRF for an input matrix or data frame.
}
\examples{
# Classification with Oblique Decision Random Forest
data(seeds)
set.seed(221212)
train <- sample(1:209, 80)
train_data <- data.frame(seeds[train, ])
test_data <- data.frame(seeds[-train, ])
forest <- ODRF(varieties_of_wheat ~ ., train_data,
  split = "entropy", parallel = FALSE, ntrees = 50
)
pred <- predict(forest, test_data[, -8], weight.tree = TRUE)
# classification error
(mean(pred != test_data[, 8]))

# Regression with Oblique Decision Random Forest
\donttest{
data(body_fat)
set.seed(221212)
train <- sample(1:252, 80)
train_data <- data.frame(body_fat[train, ])
test_data <- data.frame(body_fat[-train, ])
forest <- ODRF(Density ~ ., train_data,
  split = "mse", parallel = FALSE,
  ntrees = 50, TreeRandRotate = TRUE
)
pred <- predict(forest, test_data[, -1])
# estimation error
mean((pred - test_data[, 1])^2)
}

}
\references{
Zhan, H., Liu, Y., & Xia, Y. (2022). Consistency of The Oblique Decision Tree and Its Random Forest. arXiv preprint arXiv:2211.12653.
}
\seealso{
\code{\link{ODRF}} \code{\link{predict.ODT}}
}
\keyword{forest}
\keyword{predict}
