% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.PredictionMap}
\alias{print.PredictionMap}
\title{Prints all details about a PredictionMap object.}
\usage{
\method{print}{PredictionMap}(x, showMeta = TRUE, showPred = TRUE, ...)
}
\arguments{
\item{x}{A PredictionMap object generated by \code{\link{predictionMap}}.}

\item{showMeta}{If TRUE the meta data of the PredictionMap object will be printed.}

\item{showPred}{If TRUE the predictions of the PredictionMap object will be printed.}

\item{...}{Further parameters}
}
\description{
Prints all details about a PredictionMap object.
}
\details{
Prints all details about a given PredictionMap object and information about the meta information as well as the predictions.
}
\examples{
library(TunePareto)
data(esl)
data = esl$data
labels = esl$labels
foldList = generateCVRuns(labels  = labels,
                          ntimes      = 2,
                          nfold       = 2,
                          leaveOneOut = FALSE,
                          stratified  = TRUE)
                          
# svm with linear kernel
predMap = predictionMap(data, labels, foldList = foldList, 
                       classifier = tunePareto.svm(), kernel='linear')
                           
print(predMap, showMeta=TRUE, showPred=TRUE)
}
