% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapComp.R
\name{mapComp}
\alias{mapComp}
\title{Compare map tiles}
\usage{
mapComp(
  lat,
  long,
  data,
  types = NA,
  progress = TRUE,
  file = "mapComp.pdf",
  overwrite = FALSE,
  pargs = NULL,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{lat, long, data}{Coordinates as in \code{\link{pointsMap}}}

\item{types}{Character string vector, types for
\code{OpenStreetMap::\link[OpenStreetMap]{openmap}}
DEFAULT: NA (all current types)}

\item{progress}{Display progress bar? DEFAULT: TRUE}

\item{file}{PDF filename. Will not be overwritten unless \code{overwrite=TRUE}. 
DEFAULT: "mapComp.pdf"}

\item{overwrite}{Overwrite pdf file? DEFAULT: FALSE}

\item{pargs}{List of arguments passed to \code{\link{pdf}}. DEFAULT:NULL}

\item{quiet}{Logical: suppress non-df warning in \code{\link[berryFunctions]{getColumn}}? 
DEFAULT: FALSE}

\item{\dots}{Further arguments passed to \code{\link{pointsMap}}}
}
\value{
List of maps, writes to a pdf
}
\description{
Compare map tiles
}
\examples{
\dontrun{ # Exclude from CRAN checks because of download time
maps <- mapComp(c(52.39,52.46), c(12.99,13.06),
                pargs=list(width=8.27, height=11.96), overwrite=TRUE)

# still need to suppress output to console:
# https://stackoverflow.com/questions/45041762/suppress-rjava-error-output-in-console

unlink("mapComp.pdf")
}

}
\seealso{
\code{\link{pointsMap}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Jul 2017
}
\keyword{spatial}
