% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Graph_activeCycles.R
\name{active_cycles}
\alias{active_cycles}
\alias{has_active_cycles}
\alias{plot_active_cycles}
\title{Checks if a graph contains active cycles}
\usage{
active_cycles(DAG, early.stopping = FALSE)

has_active_cycles(DAG)

plot_active_cycles(DAG, active_cycles_list = NULL)
}
\arguments{
\item{DAG}{Directed Acyclic}

\item{early.stopping}{if \code{TRUE}, stop at the first active cycle that is
found.}

\item{active_cycles_list}{a list of active cycles as given by
\code{active_cycles}. If this is \code{NULL}, the function
\code{active_cycles} is run on \code{DAG} to find the active cycles to be
displayed.}
}
\value{
\code{active_cycles} returns a list containing the active cycles.
Each active cycle is a character vector of the name of the nodes involved in
the active cycle. The first element of this vector is the converging node of
the active cycle.

\code{has_active_cycles} returns \code{TRUE} if at least 1 active cycle is
found. Otherwise, it returns \code{FALSE}.

\code{plot_active_cycles} is called for its side-effects only. It plots the
active cycles if any, and else prints a message.
}
\description{
Checks if a graph contains active cycles
}
\examples{

DAG = create_empty_DAG(4)
DAG = bnlearn::set.arc(DAG, 'U1', 'U3')
DAG = bnlearn::set.arc(DAG, 'U2', 'U3')
DAG = bnlearn::set.arc(DAG, 'U1', 'U4')
DAG = bnlearn::set.arc(DAG, 'U2', 'U4')
DAG = bnlearn::set.arc(DAG, 'U3', 'U4')

active_cycles(DAG)  # no active cycle

DAG = create_empty_DAG(4)
DAG = bnlearn::set.arc(DAG, 'U1', 'U2')
DAG = bnlearn::set.arc(DAG, 'U1', 'U3')
DAG = bnlearn::set.arc(DAG, 'U2', 'U4')
DAG = bnlearn::set.arc(DAG, 'U3', 'U4')

active_cycles(DAG)  # 1 active cycle

DAG = create_empty_DAG(5)
DAG = bnlearn::set.arc(DAG, 'U1', 'U2')
DAG = bnlearn::set.arc(DAG, 'U1', 'U3')
DAG = bnlearn::set.arc(DAG, 'U2', 'U4')
DAG = bnlearn::set.arc(DAG, 'U3', 'U4')
DAG = bnlearn::set.arc(DAG, 'U2', 'U5')
DAG = bnlearn::set.arc(DAG, 'U3', 'U5')

active_cycles(DAG)  # 2 active cycles
active_cycles(DAG, early.stopping = TRUE)  # The first active cycle

# Plotting the active cycles
plot_active_cycles(DAG)
# which is the same as
plot_active_cycles(DAG, active_cycles_list = active_cycles(DAG))

# We now fix the active cycles by adding the some arcs.
fixedDAG = fix_active_cycles(DAG)
# We can see that no active cycles is plotted anymore
plot_active_cycles(fixedDAG)
has_active_cycles(fixedDAG)
# This is because two edges have been added, as can be seen on:
plot(fixedDAG)

}
\seealso{
the helper functions \code{\link{path_hasConvergingConnections}},
\code{\link{path_hasChords}} that are used to find the active cycles.

\code{\link{is_restrictedDAG}} to check also whether the DAG contains
interfering v-structures.
}
