% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Graph_activeCycles.R
\name{path_hasConvergingConnections}
\alias{path_hasConvergingConnections}
\alias{path_hasChords}
\title{Checks a path for converging connections and chords.}
\usage{
path_hasConvergingConnections(DAG, path)

path_hasChords(DAG, path)
}
\arguments{
\item{DAG}{Directed Acyclic Graph.}

\item{path}{character vector of nodes in the DAG forming a trail.}
}
\value{
\code{path_hasConvergingConnections} returns \code{TRUE}
if the path contains a converging connection.

\code{path_hasChords} returns \code{TRUE} if the path contains a chord.
}
\description{
Checks a path for converging connections and chords.
}
\examples{

DAG = create_empty_DAG(4)
DAG = bnlearn::set.arc(DAG, 'U1', 'U2')
DAG = bnlearn::set.arc(DAG, 'U2', 'U3')
DAG = bnlearn::set.arc(DAG, 'U3', 'U4')
path_hasConvergingConnections(DAG, c('U1', 'U2', 'U3', 'U4') ) # FALSE
path_hasChords(DAG, c('U1', 'U2', 'U3', 'U4') ) # FALSE

DAG = bnlearn::set.arc(DAG, 'U1', 'U4')
path_hasConvergingConnections(DAG, c('U1', 'U2', 'U3', 'U4') ) # FALSE
path_hasChords(DAG, c('U1', 'U2', 'U3', 'U4') ) # TRUE: has a chord

DAG = create_empty_DAG(4)
DAG = bnlearn::set.arc(DAG, 'U1', 'U2')
DAG = bnlearn::set.arc(DAG, 'U2', 'U3')
DAG = bnlearn::set.arc(DAG, 'U4', 'U3')
path_hasConvergingConnections(DAG, c('U1', 'U2', 'U3', 'U4') )
# TRUE: has a converging connection
path_hasChords(DAG, c('U1', 'U2', 'U3', 'U4') ) # FALSE

}
\seealso{
\code{\link{active_cycles}} which uses these two functions.
}
