% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLMIXfunctions.R
\name{random_start}
\alias{random_start}
\title{Appropriate simulation of starting values for tandom initialization of Gibbs Sampling. It start from the mle corresponding to no-group structure and then it randomly selects rescaled random support points (with sum 1) of G mixture components such that the marginal support coincides with the mle support for G=1
Random generation of starting values of the component-specific support parameters for Gibbs sampling}
\usage{
random_start(mlesupp, givenweights, alpha = rep(1, G))
}
\arguments{
\item{mlesupp}{MLE of support parameters}

\item{givenweights}{A numeric vector of \eqn{G} mixture weights}

\item{alpha}{A numeric vector of \eqn{G} positive reals to be used as Dirichlet parameters for the random start which corresponds to a convex combination of \eqn{G} support parameter vertices}
}
\value{
\code{out} A numeric \eqn{G}\eqn{\times}{x}\eqn{K} matrix with starting values of the component-specific support parameters
}
\description{
Appropriate simulation of starting values for tandom initialization of Gibbs Sampling. It start from the mle corresponding to no-group structure and then it randomly selects rescaled random support points (with sum 1) of G mixture components such that the marginal support coincides with the mle support for G=1
Random generation of starting values of the component-specific support parameters for Gibbs sampling
}
\author{
Cristina Mollica and Luca Tardella
}
