% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OUTmethod.R
\name{OUTmethod}
\alias{OUTmethod}
\title{Fitting potential outcome regression with different methods}
\usage{
OUTmethod(
  out.formula = out.formula,
  y = y,
  out.method = "glm",
  family = "gaussian",
  datain = datain,
  dataout = dataout,
  out.control = list()
)
}
\arguments{
\item{out.formula}{an object of class \code{\link{formula}} (or one that can be coerced to that class):
a symbolic description of the outcome model to be fitted.}

\item{y}{a vector of the observed outcome in the training data (\code{datain}).}

\item{out.method}{a character to specify the method for estimating the outcome regression model. \code{"glm"} is default, and \code{"gbm"} and \code{"SuperLearner"} are also allowed.}

\item{family}{a description of the error distribution and link function to be used in the outcome model. Supported distributional families include
\code{"gaussian" (link = identity)}, \code{"binomial" (link = logit)} and \code{"poisson" (link = log)}. Default is \code{"gaussian"}.}

\item{datain}{The training data for the outcome model. In the context of \code{PSweight}, it refers to the data observed for each treatment group.}

\item{dataout}{The prediction data for the outcome model. In the context of \code{PSweight}, it refers to the full data.}

\item{out.control}{a list to specify additional options when \code{out.method} is set to \code{"gbm"} or \code{"SuperLearner"}.}
}
\value{
\describe{

\item{\code{ m.est}}{a vector of predicted outcome on the \code{dataout}.}

\item{\code{ gamma.h}}{estimated coefficient of the outcome model when \code{method = "glm"}.}

}
}
\description{
The function \code{OUTmethod} is an internal function to estimate the potential outcomes given a specified model through formula.
It is built into function \code{PSweight}, and is used for constructing the augmented estimators.
}
\details{
A typical form for \code{out.formula} is \code{y ~ terms} where \code{y} is the outcome
variable and \code{terms} is a series of terms which specifies linear predictors (on the link function scale). \code{out.formula} by default specifies generalized
linear model given the gaussian error through the default arguments \code{method = "glm"} and \code{family = "gaussian"}.  It fits the logistic regression when \code{family = "binomal"},and poisson
regression when \code{family = "poisson"}. The argument \code{out.method} allows user to choose
model other than glm to fit the outcome regression models for constructing the augmented estimator. We have included \code{gbm} and \code{SuperLearner} as alternative machine learning estimators.
Additional argument in them can be supplied through the \code{...} argument. Please refer to the user manual of the \code{gbm} and \code{SuperLearner} packages for all the
allowed arguments.
}
\examples{
data("psdata")
#' the outcome model
out.formula <- Y~cov1+cov2+cov3+cov4+cov5+cov6
y <- psdata$Y
#train on model with treatment group 1
datain <- psdata[psdata$trt==1, ]
outfit <- OUTmethod(out.formula = out.formula, y=y, datain = datain, dataout = psdata)

}
