% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{ptsr.sim}
\alias{ptsr.sim}
\title{Function to simulate a PTSR model}
\usage{
ptsr.sim(n = 1, burn = 0, xreg = NULL, xregar = TRUE, varphi = 1,
  alpha = 0, beta = NULL, phi = NULL, theta = NULL,
  seed = stats::runif(1, 1000, 10000), rdist = r.gamma, link1 = "log",
  link2 = "identity", g1 = NULL, g1.inv = NULL, g2 = NULL)
}
\arguments{
\item{n}{a strictly positive integer. The sample size of yt (after burn-in).
Default is 1.}

\item{burn}{a non-negative integer. length of "burn-in" period. Default is 0.}

\item{xreg}{optionally, a vector or matrix of external regressors.
For simulation purposes, the length of xreg must be \code{n+burn}.
Default is \code{NULL}.}

\item{xregar}{logical, if \code{FALSE}, the regressors are not included in the
AR component of the model. Default is \code{TRUE}.}

\item{varphi}{non-negative parameter. Default is 1.}

\item{alpha}{a numeric value corresponding to the intercept.  Default is 0.}

\item{beta}{optionally, a vector of coefficients corresponding to the
regressors in \code{xreg}. Default is \code{NULL}.}

\item{phi}{optionally, for the simulation function this must be a vector
of size \eqn{p}, corresponding to the autoregressive coefficients
(including the ones that are zero), where \eqn{p} is the AR order.
Default is \code{NULL}.}

\item{theta}{optionally, for the simulation function this must be a vector
 of size \eqn{q}, corresponding to the moving average coefficients
 (including the ones that are zero), where \eqn{q} is the MA order.
 Default is \code{NULL}.
that \eqn{g_2(y_t) = 0}, for \eqn{t < 1}.}

\item{seed}{optionally, an integer which gives the value of the fixed seed to
be used by the random number generator. If missing, a random integer is
chosen uniformly from 1,000 to 10,000.}

\item{rdist}{function, the random number generator to be used}

\item{link1}{character indicating which link must be used for \eqn{\mu_t}.
See \code{\link{ptsr.link}} for available links. Default is \sQuote{log}.}

\item{link2}{character indicating which link must be used for \eqn{y_t} in
the AR recursion.  See \code{\link{ptsr.link}} for available links. Default
is \sQuote{identity}.}

\item{g1}{optionally, a link function to be used  for \eqn{\mu_t}. Default is
\code{NULL}, so that it is calculated internally, using \code{link1}.}

\item{g1.inv}{optionally, a the inverse link function to be used  for
\eqn{\eta_t}. It must the the ivnerse of \code{g1}. Default is \code{NULL},
so that it is calculated internally, using \code{link1}.}

\item{g2}{optionally, a link function to be used  for \eqn{y_t}. Default is
\code{NULL}, so that it is calculated internally, using \code{link2}.}
}
\value{
Returns a list with the following components
\itemize{

\item \code{yt}: the simulated time series

\item \code{mut}: the conditional mean

\item \code{etat}: the linear predictor \eqn{g(\mu_t)}

\item \code{error}: the error term.

}
}
\description{
Function to simulate a PTSR model
}
\details{
The function \code{ptsr.sim} generates a random sample from a positive time
series regression model, with a given distribution.
}
\examples{

#-------------------------------------------------------------------
# Generating a sample of a Gamma-ARMA(1,1) model with no regressors
#-------------------------------------------------------------------

simu <- ptsr.sim(
  n = 300, burn = 50,
  varphi = 20, alpha = 0,
  phi = 0.35, theta = 0.2,
  seed = 1234, rdist = r.gamma,
  link1 = "log", link2 = "log"
)

names(simu)
plot.ts(simu$yt)
lines(simu$mut, col = "red")

}
