% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_inp.R
\name{read_inp}
\alias{read_inp}
\title{Read capture-recapture data with Input (.inp) format used by program MARK}
\usage{
read_inp(file, group.df = NULL)
}
\arguments{
\item{file}{text file with Input format (extension .inp)}

\item{group.df}{dataframe with grouping variables; contains a row for each group defined in the input file row1=group1, row2=group2 etc. Names and number of columns in the dataframe is set by user to define grouping variables in RMark dataframe}
}
\value{
list with first component the matrix of encounter histories, second components the vector of number of individuals with corresponding histories and, if relevant, third component vector/matrix with group(s)
}
\description{
This function reads in capture-recapture dataset with the Input format.
It is a wrapper for the function convert.inp from package RMark. It drops continuous covariates because no goodness-of-fit test exists for such models
}
\examples{
# read in Dipper dataset
dipper = system.file("extdata", "ed.inp", package = "R2ucare")
read_inp(dipper,group.df=data.frame(sex=c('Male','Female')))
# read in Geese dataset
geese = system.file("extdata", "geese.inp", package = "R2ucare")
read_inp(geese)
}
\author{
Olivier Gimenez <olivier.gimenez@cefe.cnrs.fr>
}
\keyword{package}
