% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_retirement_ruin.R
\name{plot_retirement_ruin}
\alias{plot_retirement_ruin}
\title{Plotting retirement ruin}
\usage{
plot_retirement_ruin(
  portfolio_return_mean,
  portfolio_return_sd,
  age,
  gompertz_mode,
  gompertz_dispersion,
  portfolio_value,
  monthly_spendings = NULL
)
}
\arguments{
\item{portfolio_return_mean}{A numeric. Mean of portfolio returns.}

\item{portfolio_return_sd}{A numeric. Standard deviation of portfolio returns.}

\item{age}{A numeric. Current age.}

\item{gompertz_mode}{A numeric. Gompertz mode.}

\item{gompertz_dispersion}{A numeric. Gompertz dispersion.}

\item{portfolio_value}{A numeric. Initial portfolio value.}

\item{monthly_spendings}{A numeric. Monthly spendings.}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object showing the probability of
retirement ruin for different monthly spending levels.
If a specific 'monthly_spendings' value is provided,
it will be highlighted on the plot with annotations.
}
\description{
Plotting retirement ruin
}
\examples{
plot_retirement_ruin(
  portfolio_return_mean = 0.034,
  portfolio_return_sd   = 0.15,
  age                   = 65,
  gompertz_mode         = 88,
  gompertz_dispersion   = 10,
  portfolio_value       = 1000000,
  monthly_spendings     = 3000
)
}
