% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gittins.r
\name{Gittins}
\alias{Gittins}
\title{Gittins Indices}
\usage{
Gittins(Gittinstype, df)
}
\arguments{
\item{Gittinstype}{type of Gittins indices, with choices from 'Binary', 'UNKV' and 'KV'.
'Binary' represents binary outcomes, 'UNKV' and 'KV' represent continuous outcomes with
 known and unknown variance respectively.}

\item{df}{discount factor which is the multiplier for loss at each additional patient in the future.
Available values are 0.5, 0.6, 0.7, 0.8, 0.9, 0.95, 0.99 and 0.995 for \code{Gittinstype} in 'UNKV' and 'KV';
0, 0.5, 0.7, 0.99 and 0.995 for \code{Gittinstype} in 'binary'.}
}
\value{
A vector of Gittins indices for \code{Gittinstype} in 'UNKV' and 'KV'. A matrix of
Gittins indices for \code{Gittinstype} in 'Binary'.
}
\description{
\code{Gittins} can provide Gittins indices for binary reward processes
and normal reward processes with known and unknown variance for certain discount factors.
Binary reward process can handle scenarios with up to 2000 participants in a trial, while
normal reward process can handle scenarios with up to 10000 participants in a trial.
}
\details{
Gittins indices for binary outcomes are generated from \code{bmab_gi_multiple_ab} function from \code{gittins} package with
time horizon 100, 100, 100, 1000, 1000 for discount factor 0, 0.5, 0.7, 0.99 and 0.995 respectively.
Gittins indices for continuous outcomes are obtained by linear extrapolation using Table 8.1 and Table 8.3
in \insertCite{Gittins2011}{RARtrials}.
}
\examples{
Gittins(Gittinstype='KV',df=0.5)
\donttest{
Gittins(Gittinstype='Binary',df=0.995)
Gittins(Gittinstype='UNKV',df=0.99)
}
}
\references{
\insertRef{Gittins2011}{RARtrials}
}
