% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/REGIME.R
\name{apply.po.ranking}
\alias{apply.po.ranking}
\title{Apply Pre-Order Ranking (partial-order analysis)}
\usage{
apply.po.ranking(partial.order.str)
}
\arguments{
\item{partial.order.str}{An n x n character matrix containing pairwise relations. The main relation codes are:
\itemize{
\item "P+": The row alternative strictly dominates the column alternative.
\item "I": The two alternatives are indifferent.
\item "R", "-", or other placeholders can appear but are less critical here.
}}
}
\value{
A list with elements:
\itemize{
\item partial.order.str: An updated partial.order.str after merges. Dimensions may be smaller than the input.
\item partial.order.mat: An n' x n' numeric matrix of 0/1, where 1 indicates 'P+'.
\item alts: A character vector of alternative labels, possibly merged (e.g., "a2; a1").
\item alts_rank: The final ordering of alternatives from most dominating to least dominating.
\item rank: A 0/1 matrix after removing transitive edges.
}
}
\description{
This function is an R translation of the Python po.ranking() function
It merges alternatives that are 'I' (indifferent), constructs a 0/1 partial-order matrix from 'P+' entries,
sorts the alternatives by row sums, and then removes transitive edges.
}
\details{
The function is an R implementation of the pre-order rank and regime function in the pyDecision package
Source: https://github.com/Valdecy/pyDecision/blob/master/pyDecision/algorithm/regime.py
}
\examples{
# Create a small 3x3 partial-order matrix
po_str <- matrix(c("P+", "P+", "R",
                   "R",   "-",   "I",
                   "R",   "I",   "-"), nrow=3, byrow=TRUE)

# Apply the pre-order ranking
res <- apply.po.ranking(po_str)


}
